package org.concordion.internal.command;


import org.concordion.api.Evaluator;
import org.concordion.api.ResultRecorder;
import org.concordion.internal.CommandCall;
import org.concordion.internal.util.Check;

public class SetCommand extends AbstractCommand {

    @Override
    public void setUp(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        Check.isFalse(commandCall.hasChildCommands(), "Nesting commands inside a 'set' is not supported");
        evaluator.setVariable(commandCall.getExpression(), commandCall.getElement().getText());
    }
}
