/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.seam.ui.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.jboss.seam.ui.component.UIDecorate;

/**
 * "Decorate" a JSF input field when validation fails or when required="true" is set.
 **/
@Generated({"RichFaces CDK", "4.2.2.Final"})
public class HtmlDecorate extends UIDecorate
        {

    public static final String COMPONENT_TYPE="org.jboss.seam.ui.Decorate";

    public static final String COMPONENT_FAMILY="org.jboss.seam.ui.Decorate";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public HtmlDecorate() {
        super();
        setRendererType("org.jboss.seam.ui.DecorateRenderer");
    }




    protected enum Properties {
        element,
        enclose,
        forValue("for"),
        style,
        styleClass,
        template,
        title
        ;
    String toString;

    Properties(String toString) {
        this.toString = toString;
    }

    Properties() {
    }

    public String toString() {
        return ((this.toString != null) ? this.toString : super.toString());
    }
    }

 
    public String getElement() {
        String value = (String) getStateHelper().eval(Properties.element, "div");
        return value;
    }
    
    public void setElement(String element) {
        getStateHelper().put(Properties.element, element);
    }

 
    public boolean isEnclose() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.enclose, true);
        return value;
    }
    
    public void setEnclose(boolean enclose) {
        getStateHelper().put(Properties.enclose, enclose);
    }

 
    public String getFor() {
        String value = (String) getStateHelper().eval(Properties.forValue);
        return value;
    }
    
    public void setFor(String forValue) {
        getStateHelper().put(Properties.forValue, forValue);
    }

 
    public String getStyle() {
        String value = (String) getStateHelper().eval(Properties.style);
        return value;
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
        handleAttribute("style",style);
    }

 
    public String getStyleClass() {
        String value = (String) getStateHelper().eval(Properties.styleClass);
        return value;
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

 
    public String getTemplate() {
        String value = (String) getStateHelper().eval(Properties.template);
        return value;
    }
    
    public void setTemplate(String template) {
        getStateHelper().put(Properties.template, template);
    }

 
    public String getTitle() {
        String value = (String) getStateHelper().eval(Properties.title);
        return value;
    }
    
    public void setTitle(String title) {
        getStateHelper().put(Properties.title, title);
        handleAttribute("title",title);
    }
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = "javax.faces.component.UIComponentBase.attributesThatAreSet";
    
    private void handleAttribute(String name, Object value) {
        List<String> setAttributes = (List<String>) this.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
        if (setAttributes == null) {
                setAttributes = new ArrayList<String>(2);
                this.getAttributes().put(ATTRIBUTES_THAT_ARE_SET_KEY, setAttributes);
        }
        if (value == null) {
                ValueExpression ve = getValueExpression(name);
                if (ve == null) {
                    setAttributes.remove(name);
                }
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
        }
    }    

    

}