/*
 * (C) Copyright 2006-2013 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nelson Silva <nelson.silva@inevo.pt> - initial API and implementation
 *     Nuxeo
 */
package org.nuxeo.ecm.platform.oauth2.providers;

import java.util.List;

public interface OAuth2ServiceProviderRegistry {
    NuxeoOAuth2ServiceProvider getProvider(String serviceName);

    NuxeoOAuth2ServiceProvider addProvider(String serviceName,
            String tokenServerURL, String authorizationServerURL,
            String clientId, String clientSecret, List<String> scopes)
            throws Exception;
}
