/*
 * Licensed to Elasticsearch under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.elasticsearch.rest;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.logging.ESLogger;

import java.io.IOException;

/**
 */
public abstract class AbstractRestResponseActionListener<T extends ActionResponse> implements ActionListener<T> {

    protected final RestChannel channel;
    protected final RestRequest request;
    protected final ESLogger logger;

    public AbstractRestResponseActionListener(final RestRequest request, final RestChannel channel, final ESLogger logger) {
        this.request = request;
        this.channel = channel;
        this.logger = logger;
    }

    @Override
    public abstract void onResponse(T t);

    @Override
    public void onFailure(Throwable e) {
        try {
            channel.sendResponse(new XContentThrowableRestResponse(request, e));
        } catch (IOException e1) {
            logger.error("Failed to send failure response", e1);
        }
    }
}
