/*
 * (C) Copyright 2006-2007 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id:ContentHistoryBusinessDelegate.java 3895 2006-10-11 19:12:47Z janguenot $
 */

package org.nuxeo.ecm.platform.audit.ws.delegate;

import java.io.Serializable;

import javax.naming.NamingException;

import org.nuxeo.ecm.platform.audit.ws.api.WSAudit;

/**
 * Audit Web service business delegate.
 *
 * @author <a href="mailto:ja@nuxeo.com">Julien Anguenot</a>
 */
public class WSAuditBeanBusinessDelegate implements Serializable {

    private static final long serialVersionUID = 1L;

    protected WSAudit ws;

    public WSAudit getWSAuditRemote() throws NamingException {
        if (ws == null) {
            ws = EJBFactory.getWSAuditRemote();
        }
        return ws;
    }

}
