/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $

/**
 * Implementation of DateTimeFormatInfo for the "eu" locale.
 */
public class DateTimeFormatInfoImpl_eu extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "EEEE, y'eko' MMMM'ren' dd'a'";
  }

  @Override
  public String dateFormatLong() {
    return "y'eko' MMM'ren' dd'a'";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "K.a.",
        "K.o."
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "K.a.",
        "K.o."
    };
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, MMMM d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "MMM d, y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "MMMM d, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "M/d/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "urtarrila",
        "otsaila",
        "martxoa",
        "apirila",
        "maiatza",
        "ekaina",
        "uztaila",
        "abuztua",
        "iraila",
        "urria",
        "azaroa",
        "abendua"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "U",
        "O",
        "M",
        "A",
        "M",
        "E",
        "U",
        "A",
        "I",
        "U",
        "A",
        "A"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "urt",
        "ots",
        "mar",
        "api",
        "mai",
        "eka",
        "uzt",
        "abu",
        "ira",
        "urr",
        "aza",
        "abe"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1. hiruhilekoa",
        "2. hiruhilekoa",
        "3. hiruhilekoa",
        "4. hiruhilekoa"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "1Hh",
        "2Hh",
        "3Hh",
        "4Hh"
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "igandea",
        "astelehena",
        "asteartea",
        "asteazkena",
        "osteguna",
        "ostirala",
        "larunbata"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "I",
        "M",
        "A",
        "A",
        "A",
        "O",
        "I"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return new String[] {
        "I",
        "M",
        "A",
        "L",
        "A",
        "O",
        "I"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "ig",
        "al",
        "as",
        "az",
        "og",
        "or",
        "lr"
    };
  }
}
