/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $
//  type=root


/**
 * Localized names for the "vi" locale.
 */
public class LocalizedNamesImpl_vi extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "VN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AR",
        "AM",
        "EG",
        "AZ",
        "IE",
        "IS",
        "AL",
        "AD",
        "DZ",
        "AI",
        "AG",
        "AT",
        "AF",
        "SA",
        "AW",
        "AO",
        "IN",
        "BB",
        "BS",
        "PL",
        "BH",
        "KP",
        "GL",
        "BD",
        "BM",
        "BY",
        "BZ",
        "BJ",
        "BE",
        "BL",
        "PT",
        "BO",
        "BW",
        "BA",
        "CI",
        "BQ",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "UM",
        "AE",
        "CM",
        "KH",
        "CA",
        "CV",
        "QA",
        "EA",
        "CL",
        "CO",
        "KM",
        "CG",
        "CD",
        "DO",
        "CZ",
        "CF",
        "KW",
        "CR",
        "HR",
        "CU",
        "KG",
        "CW",
        "ZM",
        "DG",
        "ZW",
        "DM",
        "TW",
        "DK",
        "AC",
        "BV",
        "CP",
        "CX",
        "GU",
        "HM",
        "IM",
        "NF",
        "AS",
        "VG",
        "TL",
        "DE",
        "SV",
        "EE",
        "EC",
        "ER",
        "ET",
        "GA",
        "GM",
        "GH",
        "GN",
        "GW",
        "GQ",
        "GI",
        "DJ",
        "JO",
        "GT",
        "GD",
        "GE",
        "GP",
        "GG",
        "GY",
        "HT",
        "NL",
        "JM",
        "KR",
        "US",
        "HN",
        "HK",
        "HU",
        "GR",
        "IR",
        "IQ",
        "IL",
        "JE",
        "KZ",
        "KE",
        "KI",
        "PS",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "EU",
        "LT",
        "LU",
        "MO",
        "MG",
        "MW",
        "MY",
        "ML",
        "MV",
        "MT",
        "MA",
        "MK",
        "MX",
        "MF",
        "MM",
        "FM",
        "ME",
        "MS",
        "MZ",
        "MC",
        "MD",
        "MN",
        "MR",
        "MU",
        "MQ",
        "AQ",
        "ID",
        "NA",
        "ZA",
        "NR",
        "NO",
        "NC",
        "NP",
        "RU",
        "JP",
        "NI",
        "NE",
        "NG",
        "NZ",
        "NU",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "FR",
        "FI",
        "FJ",
        "PH",
        "PF",
        "PR",
        "AX",
        "MP",
        "IC",
        "KY",
        "CC",
        "CK",
        "FK",
        "FO",
        "MH",
        "GS",
        "PN",
        "TC",
        "VI",
        "SB",
        "GF",
        "RE",
        "RW",
        "RO",
        "SH",
        "PM",
        "TD",
        "CS",
        "CY",
        "SS",
        "SJ",
        "SX",
        "TZ",
        "TJ",
        "AN",
        "ES",
        "EH",
        "TH",
        "TR",
        "IO",
        "TF",
        "SE",
        "CH",
        "TK",
        "TG",
        "TO",
        "TT",
        "TA",
        "CN",
        "TM",
        "TV",
        "TN",
        "AU",
        "UA",
        "UZ",
        "UG",
        "UY",
        "VU",
        "VA",
        "VE",
        "VN",
        "QO",
        "GB",
        "WF",
        "WS",
        "KN",
        "LC",
        "SM",
        "VC",
        "ST",
        "SC",
        "RS",
        "SN",
        "SL",
        "SG",
        "SY",
        "SK",
        "SI",
        "SZ",
        "SO",
        "LK",
        "SD",
        "SR",
        "IT",
        "YE",
        "YT",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Thế giới");
    namesMap.put("002", "Châu Phi");
    namesMap.put("003", "Bắc Mỹ");
    namesMap.put("005", "Nam Mỹ");
    namesMap.put("009", "Châu Đại Dương");
    namesMap.put("011", "Tây Phi");
    namesMap.put("013", "Trung Mỹ");
    namesMap.put("014", "Đông Phí");
    namesMap.put("015", "Bắc Phi");
    namesMap.put("017", "Trung Phi");
    namesMap.put("018", "Miền Nam Châu Phi");
    namesMap.put("019", "Châu Mỹ");
    namesMap.put("021", "Miền Bắc Châu Mỹ");
    namesMap.put("029", "Ca-ri-bê");
    namesMap.put("030", "Đông Á");
    namesMap.put("034", "Nam Á");
    namesMap.put("035", "Đông Nam Á");
    namesMap.put("039", "Nam Âu");
    namesMap.put("053", "Úc và New Zealand");
    namesMap.put("057", "Vùng Micronesian");
    namesMap.put("142", "Châu Á");
    namesMap.put("143", "Trung Á");
    namesMap.put("145", "Tây Á");
    namesMap.put("150", "Âu Châu");
    namesMap.put("151", "Đông Âu");
    namesMap.put("154", "Miền Bắc Châu Âu");
    namesMap.put("155", "Tây Âu");
    namesMap.put("419", "Châu Mỹ La-tinh");
    namesMap.put("AC", "Đảo Ascension");
    namesMap.put("AE", "Các Tiểu Vương quốc A-rập Thống nhất");
    namesMap.put("AF", "Áp-ga-ni-xtan");
    namesMap.put("AG", "An-ti-gu-a và Ba-bu-đa");
    namesMap.put("AL", "An-ba-ni");
    namesMap.put("AM", "Ác-mê-ni-a");
    namesMap.put("AN", "Tây Ấn Hà Lan");
    namesMap.put("AO", "Ăng-gô-la");
    namesMap.put("AQ", "Nam Cực");
    namesMap.put("AR", "Ác-hen-ti-na");
    namesMap.put("AS", "Đảo Somoa thuộc Mỹ");
    namesMap.put("AT", "Áo");
    namesMap.put("AU", "Úc");
    namesMap.put("AX", "Quần đảo Aland");
    namesMap.put("AZ", "Ai-déc-bai-gian");
    namesMap.put("BA", "Bô-xni-a Héc-xê-gô-vi-na");
    namesMap.put("BB", "Bác-ba-đốt");
    namesMap.put("BD", "Băng-la-đét");
    namesMap.put("BE", "Bỉ");
    namesMap.put("BF", "Buốc-ki-na Pha-xô");
    namesMap.put("BG", "Bun-ga-ri");
    namesMap.put("BH", "Ba-ren");
    namesMap.put("BI", "Bu-run-đi");
    namesMap.put("BJ", "Bê-nanh");
    namesMap.put("BN", "Bru-nây");
    namesMap.put("BO", "Bô-li-vi-a");
    namesMap.put("BR", "Bra-xin");
    namesMap.put("BS", "Ba-ha-ma");
    namesMap.put("BT", "Bu-tan (Bhutan)");
    namesMap.put("BV", "Đảo Bouvet (Na Uy)");
    namesMap.put("BW", "Bốt-xoa-na");
    namesMap.put("BY", "Bê-la-rút");
    namesMap.put("BZ", "Bê-li-xê");
    namesMap.put("CA", "Ca-na-đa");
    namesMap.put("CC", "Quần đảo Cocos");
    namesMap.put("CD", "Cộng hoà dân chủ Côngô");
    namesMap.put("CF", "Cộng hòa Trung Phi");
    namesMap.put("CG", "Công-gô");
    namesMap.put("CH", "Thụy Sĩ");
    namesMap.put("CI", "Bờ Biển Ngà");
    namesMap.put("CK", "Quần Đảo Cook");
    namesMap.put("CL", "Chi-lê");
    namesMap.put("CM", "Ca-mơ-run");
    namesMap.put("CN", "Trung Quốc");
    namesMap.put("CO", "Cô-lôm-bi-a");
    namesMap.put("CP", "Đảo Clipperton");
    namesMap.put("CR", "Cốt-xta Ri-ca");
    namesMap.put("CS", "Séc-bia");
    namesMap.put("CU", "Cu Ba");
    namesMap.put("CV", "Cáp-ve");
    namesMap.put("CX", "Đảo Giáng Sinh");
    namesMap.put("CY", "Síp");
    namesMap.put("CZ", "Cộng hòa Séc");
    namesMap.put("DE", "Đức");
    namesMap.put("DJ", "Gi-bu-ti");
    namesMap.put("DK", "Đan Mạch");
    namesMap.put("DO", "Cộng hoà Đô-mi-ni-ca");
    namesMap.put("DZ", "An-giê-ri");
    namesMap.put("EA", "Ceuta và Melilla");
    namesMap.put("EC", "Ê-cu-a-đo");
    namesMap.put("EE", "E-xtô-ni-a");
    namesMap.put("EG", "Ai Cập");
    namesMap.put("EH", "Tây Sahara");
    namesMap.put("ER", "Ê-ri-tơ-rê-a");
    namesMap.put("ES", "Tây Ban Nha");
    namesMap.put("ET", "Ê-ti-ô-pi-a");
    namesMap.put("EU", "Liên Minh Châu Âu");
    namesMap.put("FI", "Phần Lan");
    namesMap.put("FJ", "Phi-gi");
    namesMap.put("FK", "Quần Đảo Falkland");
    namesMap.put("FM", "Mi-crô-nê-xi-a");
    namesMap.put("FO", "Quần Đảo Faroe");
    namesMap.put("FR", "Pháp");
    namesMap.put("GA", "Ga-bông");
    namesMap.put("GB", "Vương quốc Anh");
    namesMap.put("GD", "Grê-na-đa");
    namesMap.put("GE", "Gru-di-a");
    namesMap.put("GF", "Quiana thuộc Pháp");
    namesMap.put("GH", "Gha-na");
    namesMap.put("GL", "Băng Đảo");
    namesMap.put("GM", "Găm-bi-a");
    namesMap.put("GN", "Ghi-nê");
    namesMap.put("GQ", "Ghi-nê Xích-đạo");
    namesMap.put("GR", "Hy Lạp");
    namesMap.put("GS", "Quần đảo Nam Georgia và Nam Sandwich");
    namesMap.put("GT", "Goa-tê-ma-la");
    namesMap.put("GU", "Đảo Gu-am");
    namesMap.put("GW", "Ghi-nê Bít-xao");
    namesMap.put("GY", "Guy-a-na");
    namesMap.put("HK", "Hồng Kông");
    namesMap.put("HM", "Đảo Heard và Quần đảo McDonald");
    namesMap.put("HN", "Hôn-đu-rát");
    namesMap.put("HR", "Crô-a-ti-a");
    namesMap.put("HT", "Ha-i-ti");
    namesMap.put("HU", "Hung-ga-ri");
    namesMap.put("IC", "Quần đảo Canary");
    namesMap.put("ID", "Nam Dương");
    namesMap.put("IE", "Ai-len");
    namesMap.put("IL", "I-xra-en");
    namesMap.put("IM", "Đảo Man");
    namesMap.put("IN", "Ấn Độ");
    namesMap.put("IO", "Thuộc địa Anh tại Ấn Độ Dương");
    namesMap.put("IQ", "I-rắc");
    namesMap.put("IR", "I-ran");
    namesMap.put("IS", "Ai-xơ-len");
    namesMap.put("IT", "Ý");
    namesMap.put("JM", "Ha-mai-ca");
    namesMap.put("JO", "Gióc-đa-ni");
    namesMap.put("JP", "Nhật Bản");
    namesMap.put("KE", "Kê-ni-a");
    namesMap.put("KG", "Cư-rơ-gư-xtan");
    namesMap.put("KH", "Campuchia");
    namesMap.put("KI", "Ki-ri-ba-ti");
    namesMap.put("KM", "Cô-mô");
    namesMap.put("KN", "Xan-kít và Nê-vi");
    namesMap.put("KP", "Bắc Triều Tiên");
    namesMap.put("KR", "Hàn Quốc");
    namesMap.put("KW", "Cô-oét");
    namesMap.put("KY", "Quần Đảo Cayman");
    namesMap.put("KZ", "Ka-dắc-xtan");
    namesMap.put("LA", "Lào");
    namesMap.put("LB", "Li-băng");
    namesMap.put("LC", "Xan Lu-xi");
    namesMap.put("LI", "Lich-ten-xtên");
    namesMap.put("LK", "Xri Lan-ca");
    namesMap.put("LR", "Li-bê-ri-a");
    namesMap.put("LS", "Lê-xô-thô");
    namesMap.put("LT", "Li-tu-a-ni-a");
    namesMap.put("LU", "Lúc-xăm-bua");
    namesMap.put("LV", "Lát-vi-a");
    namesMap.put("LY", "Li-bi");
    namesMap.put("MA", "Ma-rốc");
    namesMap.put("MC", "Mô-na-cô");
    namesMap.put("MD", "Môn-đô-va");
    namesMap.put("MG", "Ma-đa-gát-xca");
    namesMap.put("MH", "Quần đảo Mác-san");
    namesMap.put("MK", "Ma-xê-đô-ni-a");
    namesMap.put("ML", "Ma-li");
    namesMap.put("MM", "Mi-an-ma");
    namesMap.put("MN", "Mông Cổ");
    namesMap.put("MO", "Macao");
    namesMap.put("MP", "Quần Đảo Bắc Mariana");
    namesMap.put("MR", "Mô-ri-ta-ni");
    namesMap.put("MT", "Man-ta");
    namesMap.put("MU", "Mô-ri-xơ");
    namesMap.put("MV", "Man-đi-vơ");
    namesMap.put("MW", "Ma-la-uy");
    namesMap.put("MX", "Mê-hi-cô");
    namesMap.put("MY", "Ma-lay-xi-a");
    namesMap.put("MZ", "Mô-dăm-bích");
    namesMap.put("NA", "Nam-mi-bi-a");
    namesMap.put("NE", "Ni-giê");
    namesMap.put("NF", "Đảo Norfolk");
    namesMap.put("NG", "Ni-giê-ri-a");
    namesMap.put("NI", "Ni-ca-ra-goa");
    namesMap.put("NL", "Hà Lan");
    namesMap.put("NO", "Na Uy");
    namesMap.put("NP", "Nê-pan");
    namesMap.put("NZ", "Niu Di-lân");
    namesMap.put("OM", "Ô-man");
    namesMap.put("PA", "Pa-na-ma");
    namesMap.put("PE", "Pê-ru");
    namesMap.put("PF", "Polynesia thuộc Pháp");
    namesMap.put("PG", "Pa-pu-a Niu Ghi-nê");
    namesMap.put("PH", "Phi-lip-pin");
    namesMap.put("PK", "Pa-ki-xtan");
    namesMap.put("PL", "Ba Lan");
    namesMap.put("PM", "Saint Pierre và Miquelon");
    namesMap.put("PN", "Quần đảo Pitcairn");
    namesMap.put("PS", "Lãnh thổ Palestine");
    namesMap.put("PT", "Bồ Đào Nha");
    namesMap.put("PY", "Pa-ra-goay");
    namesMap.put("QA", "Ca-ta");
    namesMap.put("QO", "Vùng xa xôi thuộc Châu Đại Dương");
    namesMap.put("RO", "Ru-ma-ni");
    namesMap.put("RS", "Xéc-bi");
    namesMap.put("RU", "Nga");
    namesMap.put("RW", "Ru-an-đa");
    namesMap.put("SA", "A-rập Xê-út");
    namesMap.put("SB", "Quần đảo Xô-lô-mông");
    namesMap.put("SC", "Xây-sen");
    namesMap.put("SD", "Xu-đăng");
    namesMap.put("SE", "Thụy Điển");
    namesMap.put("SG", "Xin-ga-po");
    namesMap.put("SI", "Xlô-ven-ni-a");
    namesMap.put("SJ", "Svalbard và Jan Mayen");
    namesMap.put("SK", "Xlô-va-ki-a");
    namesMap.put("SL", "Xi-ê-ra Lê-ôn");
    namesMap.put("SM", "Xan Ma-ri-nô");
    namesMap.put("SN", "Xê-nê-gan");
    namesMap.put("SO", "Xô-ma-li");
    namesMap.put("SR", "Xu-ri-nam");
    namesMap.put("ST", "Xao Tô-mê và Prin-xi-pê");
    namesMap.put("SV", "En-san-va-đo");
    namesMap.put("SY", "Xi-ri");
    namesMap.put("SZ", "Xoa-di-len");
    namesMap.put("TC", "Quần Đảo Turk và Caicos");
    namesMap.put("TD", "Sát");
    namesMap.put("TF", "Thuộc Địa Nam của Pháp");
    namesMap.put("TG", "Tô-gô");
    namesMap.put("TH", "Thái Lan");
    namesMap.put("TJ", "Tát-gi-ki-xtan");
    namesMap.put("TL", "Đông Ti-mo");
    namesMap.put("TM", "Tuốc-mê-ni-xtan");
    namesMap.put("TN", "Tuy-ni-di");
    namesMap.put("TO", "Tông-ga");
    namesMap.put("TR", "Thổ Nhĩ Kỳ");
    namesMap.put("TT", "Tri-ni-đát và Tô-ba-gô");
    namesMap.put("TV", "Tu-va-lu");
    namesMap.put("TW", "Đài Loan");
    namesMap.put("TZ", "Tan-da-ni-a");
    namesMap.put("UA", "U-crai-na");
    namesMap.put("UG", "U-gan-đa");
    namesMap.put("UM", "Các đảo nhỏ xa trung tâm thuộc Mỹ");
    namesMap.put("US", "Hoa Kỳ");
    namesMap.put("UY", "U-ru-goay");
    namesMap.put("UZ", "U-dơ-bê-ki-xtan");
    namesMap.put("VA", "Va-ti-căng");
    namesMap.put("VC", "Xan Vin-xen và Grê-na-din");
    namesMap.put("VE", "Vê-nê-zu-ê-la");
    namesMap.put("VG", "Đảo Virgin, thuộc Anh");
    namesMap.put("VI", "Quần đảo Virgin, Mỹ");
    namesMap.put("VN", "Việt Nam");
    namesMap.put("VU", "Va-nu-a-tu");
    namesMap.put("WF", "Wallis và Futuna");
    namesMap.put("WS", "Xa-moa");
    namesMap.put("YE", "Y-ê-men");
    namesMap.put("ZA", "Nam Phi");
    namesMap.put("ZM", "Dăm-bi-a");
    namesMap.put("ZW", "Dim-ba-bu-ê");
    namesMap.put("ZZ", "Vùng Chưa biết hoặc không Hợp lệ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Thế giới",
        "002": "Châu Phi",
        "003": "Bắc Mỹ",
        "005": "Nam Mỹ",
        "009": "Châu Đại Dương",
        "011": "Tây Phi",
        "013": "Trung Mỹ",
        "014": "Đông Phí",
        "015": "Bắc Phi",
        "017": "Trung Phi",
        "018": "Miền Nam Châu Phi",
        "019": "Châu Mỹ",
        "021": "Miền Bắc Châu Mỹ",
        "029": "Ca-ri-bê",
        "030": "Đông Á",
        "034": "Nam Á",
        "035": "Đông Nam Á",
        "039": "Nam Âu",
        "053": "Úc và New Zealand",
        "057": "Vùng Micronesian",
        "142": "Châu Á",
        "143": "Trung Á",
        "145": "Tây Á",
        "150": "Âu Châu",
        "151": "Đông Âu",
        "154": "Miền Bắc Châu Âu",
        "155": "Tây Âu",
        "419": "Châu Mỹ La-tinh",
        "AC": "Đảo Ascension",
        "AE": "Các Tiểu Vương quốc A-rập Thống nhất",
        "AF": "Áp-ga-ni-xtan",
        "AG": "An-ti-gu-a và Ba-bu-đa",
        "AL": "An-ba-ni",
        "AM": "Ác-mê-ni-a",
        "AN": "Tây Ấn Hà Lan",
        "AO": "Ăng-gô-la",
        "AQ": "Nam Cực",
        "AR": "Ác-hen-ti-na",
        "AS": "Đảo Somoa thuộc Mỹ",
        "AT": "Áo",
        "AU": "Úc",
        "AX": "Quần đảo Aland",
        "AZ": "Ai-déc-bai-gian",
        "BA": "Bô-xni-a Héc-xê-gô-vi-na",
        "BB": "Bác-ba-đốt",
        "BD": "Băng-la-đét",
        "BE": "Bỉ",
        "BF": "Buốc-ki-na Pha-xô",
        "BG": "Bun-ga-ri",
        "BH": "Ba-ren",
        "BI": "Bu-run-đi",
        "BJ": "Bê-nanh",
        "BN": "Bru-nây",
        "BO": "Bô-li-vi-a",
        "BR": "Bra-xin",
        "BS": "Ba-ha-ma",
        "BT": "Bu-tan (Bhutan)",
        "BV": "Đảo Bouvet (Na Uy)",
        "BW": "Bốt-xoa-na",
        "BY": "Bê-la-rút",
        "BZ": "Bê-li-xê",
        "CA": "Ca-na-đa",
        "CC": "Quần đảo Cocos",
        "CD": "Cộng hoà dân chủ Côngô",
        "CF": "Cộng hòa Trung Phi",
        "CG": "Công-gô",
        "CH": "Thụy Sĩ",
        "CI": "Bờ Biển Ngà",
        "CK": "Quần Đảo Cook",
        "CL": "Chi-lê",
        "CM": "Ca-mơ-run",
        "CN": "Trung Quốc",
        "CO": "Cô-lôm-bi-a",
        "CP": "Đảo Clipperton",
        "CR": "Cốt-xta Ri-ca",
        "CS": "Séc-bia",
        "CU": "Cu Ba",
        "CV": "Cáp-ve",
        "CX": "Đảo Giáng Sinh",
        "CY": "Síp",
        "CZ": "Cộng hòa Séc",
        "DE": "Đức",
        "DJ": "Gi-bu-ti",
        "DK": "Đan Mạch",
        "DO": "Cộng hoà Đô-mi-ni-ca",
        "DZ": "An-giê-ri",
        "EA": "Ceuta và Melilla",
        "EC": "Ê-cu-a-đo",
        "EE": "E-xtô-ni-a",
        "EG": "Ai Cập",
        "EH": "Tây Sahara",
        "ER": "Ê-ri-tơ-rê-a",
        "ES": "Tây Ban Nha",
        "ET": "Ê-ti-ô-pi-a",
        "EU": "Liên Minh Châu Âu",
        "FI": "Phần Lan",
        "FJ": "Phi-gi",
        "FK": "Quần Đảo Falkland",
        "FM": "Mi-crô-nê-xi-a",
        "FO": "Quần Đảo Faroe",
        "FR": "Pháp",
        "GA": "Ga-bông",
        "GB": "Vương quốc Anh",
        "GD": "Grê-na-đa",
        "GE": "Gru-di-a",
        "GF": "Quiana thuộc Pháp",
        "GH": "Gha-na",
        "GL": "Băng Đảo",
        "GM": "Găm-bi-a",
        "GN": "Ghi-nê",
        "GQ": "Ghi-nê Xích-đạo",
        "GR": "Hy Lạp",
        "GS": "Quần đảo Nam Georgia và Nam Sandwich",
        "GT": "Goa-tê-ma-la",
        "GU": "Đảo Gu-am",
        "GW": "Ghi-nê Bít-xao",
        "GY": "Guy-a-na",
        "HK": "Hồng Kông",
        "HM": "Đảo Heard và Quần đảo McDonald",
        "HN": "Hôn-đu-rát",
        "HR": "Crô-a-ti-a",
        "HT": "Ha-i-ti",
        "HU": "Hung-ga-ri",
        "IC": "Quần đảo Canary",
        "ID": "Nam Dương",
        "IE": "Ai-len",
        "IL": "I-xra-en",
        "IM": "Đảo Man",
        "IN": "Ấn Độ",
        "IO": "Thuộc địa Anh tại Ấn Độ Dương",
        "IQ": "I-rắc",
        "IR": "I-ran",
        "IS": "Ai-xơ-len",
        "IT": "Ý",
        "JM": "Ha-mai-ca",
        "JO": "Gióc-đa-ni",
        "JP": "Nhật Bản",
        "KE": "Kê-ni-a",
        "KG": "Cư-rơ-gư-xtan",
        "KH": "Campuchia",
        "KI": "Ki-ri-ba-ti",
        "KM": "Cô-mô",
        "KN": "Xan-kít và Nê-vi",
        "KP": "Bắc Triều Tiên",
        "KR": "Hàn Quốc",
        "KW": "Cô-oét",
        "KY": "Quần Đảo Cayman",
        "KZ": "Ka-dắc-xtan",
        "LA": "Lào",
        "LB": "Li-băng",
        "LC": "Xan Lu-xi",
        "LI": "Lich-ten-xtên",
        "LK": "Xri Lan-ca",
        "LR": "Li-bê-ri-a",
        "LS": "Lê-xô-thô",
        "LT": "Li-tu-a-ni-a",
        "LU": "Lúc-xăm-bua",
        "LV": "Lát-vi-a",
        "LY": "Li-bi",
        "MA": "Ma-rốc",
        "MC": "Mô-na-cô",
        "MD": "Môn-đô-va",
        "MG": "Ma-đa-gát-xca",
        "MH": "Quần đảo Mác-san",
        "MK": "Ma-xê-đô-ni-a",
        "ML": "Ma-li",
        "MM": "Mi-an-ma",
        "MN": "Mông Cổ",
        "MO": "Macao",
        "MP": "Quần Đảo Bắc Mariana",
        "MR": "Mô-ri-ta-ni",
        "MT": "Man-ta",
        "MU": "Mô-ri-xơ",
        "MV": "Man-đi-vơ",
        "MW": "Ma-la-uy",
        "MX": "Mê-hi-cô",
        "MY": "Ma-lay-xi-a",
        "MZ": "Mô-dăm-bích",
        "NA": "Nam-mi-bi-a",
        "NE": "Ni-giê",
        "NF": "Đảo Norfolk",
        "NG": "Ni-giê-ri-a",
        "NI": "Ni-ca-ra-goa",
        "NL": "Hà Lan",
        "NO": "Na Uy",
        "NP": "Nê-pan",
        "NZ": "Niu Di-lân",
        "OM": "Ô-man",
        "PA": "Pa-na-ma",
        "PE": "Pê-ru",
        "PF": "Polynesia thuộc Pháp",
        "PG": "Pa-pu-a Niu Ghi-nê",
        "PH": "Phi-lip-pin",
        "PK": "Pa-ki-xtan",
        "PL": "Ba Lan",
        "PM": "Saint Pierre và Miquelon",
        "PN": "Quần đảo Pitcairn",
        "PS": "Lãnh thổ Palestine",
        "PT": "Bồ Đào Nha",
        "PY": "Pa-ra-goay",
        "QA": "Ca-ta",
        "QO": "Vùng xa xôi thuộc Châu Đại Dương",
        "RO": "Ru-ma-ni",
        "RS": "Xéc-bi",
        "RU": "Nga",
        "RW": "Ru-an-đa",
        "SA": "A-rập Xê-út",
        "SB": "Quần đảo Xô-lô-mông",
        "SC": "Xây-sen",
        "SD": "Xu-đăng",
        "SE": "Thụy Điển",
        "SG": "Xin-ga-po",
        "SI": "Xlô-ven-ni-a",
        "SJ": "Svalbard và Jan Mayen",
        "SK": "Xlô-va-ki-a",
        "SL": "Xi-ê-ra Lê-ôn",
        "SM": "Xan Ma-ri-nô",
        "SN": "Xê-nê-gan",
        "SO": "Xô-ma-li",
        "SR": "Xu-ri-nam",
        "ST": "Xao Tô-mê và Prin-xi-pê",
        "SV": "En-san-va-đo",
        "SY": "Xi-ri",
        "SZ": "Xoa-di-len",
        "TC": "Quần Đảo Turk và Caicos",
        "TD": "Sát",
        "TF": "Thuộc Địa Nam của Pháp",
        "TG": "Tô-gô",
        "TH": "Thái Lan",
        "TJ": "Tát-gi-ki-xtan",
        "TL": "Đông Ti-mo",
        "TM": "Tuốc-mê-ni-xtan",
        "TN": "Tuy-ni-di",
        "TO": "Tông-ga",
        "TR": "Thổ Nhĩ Kỳ",
        "TT": "Tri-ni-đát và Tô-ba-gô",
        "TV": "Tu-va-lu",
        "TW": "Đài Loan",
        "TZ": "Tan-da-ni-a",
        "UA": "U-crai-na",
        "UG": "U-gan-đa",
        "UM": "Các đảo nhỏ xa trung tâm thuộc Mỹ",
        "US": "Hoa Kỳ",
        "UY": "U-ru-goay",
        "UZ": "U-dơ-bê-ki-xtan",
        "VA": "Va-ti-căng",
        "VC": "Xan Vin-xen và Grê-na-din",
        "VE": "Vê-nê-zu-ê-la",
        "VG": "Đảo Virgin, thuộc Anh",
        "VI": "Quần đảo Virgin, Mỹ",
        "VN": "Việt Nam",
        "VU": "Va-nu-a-tu",
        "WF": "Wallis và Futuna",
        "WS": "Xa-moa",
        "YE": "Y-ê-men",
        "ZA": "Nam Phi",
        "ZM": "Dăm-bi-a",
        "ZW": "Dim-ba-bu-ê",
        "ZZ": "Vùng Chưa biết hoặc không Hợp lệ"
    };
  }-*/;
}
