/*
 * Copyright (c) 2003-2006 OFFIS, Henri Tremblay. 
 * This program is made available under the terms of the MIT License.
 */
package org.easymock.classextension;

import java.lang.reflect.Method;

import org.easymock.classextension.internal.ClassExtensionHelper;
import org.easymock.classextension.internal.MocksClassControl;
import org.easymock.internal.MocksControl;

public class EasyMock extends org.easymock.EasyMock {

    public static <T> T createStrictMock(Class<T> toMock) {
        return createStrictControl().createMock(toMock);
    }

    public static <T> T createStrictMock(Class<T> toMock, Method[] mockedMethods) {
        return createStrictControl().createMock(toMock, mockedMethods);
    }

    public static <T> T createMock(Class<T> toMock) {
        return createControl().createMock(toMock);
    }

    public static <T> T createMock(Class<T> toMock, Method[] mockedMethods) {
        return createControl().createMock(toMock, mockedMethods);
    }

    public static <T> T createNiceMock(Class<T> toMock) {
        return createNiceControl().createMock(toMock);
    }

    public static <T> T createNiceMock(Class<T> toMock, Method[] mockedMethods) {
        return createNiceControl().createMock(toMock, mockedMethods);
    }

    public static IMocksControl createStrictControl() {
        return new MocksClassControl(MocksControl.MockType.STRICT);
    }

    public static IMocksControl createControl() {
        return new MocksClassControl(MocksControl.MockType.DEFAULT);
    }

    public static IMocksControl createNiceControl() {
        return new MocksClassControl(MocksControl.MockType.NICE);
    }

    public static void replay(Object... mocks) {
        for (Object mock : mocks) {
            ClassExtensionHelper.getControl(mock).replay();
        }
    }

    public static void reset(Object... mocks) {
        for (Object mock : mocks) {
            ClassExtensionHelper.getControl(mock).reset();
        }
    }

    public static void verify(Object... mocks) {
        for (Object mock : mocks) {
            ClassExtensionHelper.getControl(mock).verify();
        }
    }

    public static void checkOrder(Object mock, boolean value) {
        ClassExtensionHelper.getControl(mock).checkOrder(value);
    }
}
