/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


package org.tranql.connector.jdbc;

import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.tranql.connector.NoExceptionsAreFatalSorter;

/**
 * @version $Rev:$ $Date:$
 */
public class LocalDataSourceWrapper extends AbstractLocalDataSourceMCF<DataSource> {

    private static final long serialVersionUID = -1728332665706308379L;
    private String userName;
    private String password;

    public LocalDataSourceWrapper(DataSource datasource) {
        super(datasource, new KnownSQLStateExceptionSorter(), true);
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

}
