/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.core.configuration;


import java.util.Set;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;


/**
 * A mutable version of {@link PartitionConfiguration}.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev: 556219 $, $Date: 2007-07-14 00:01:36 -0400 (Sat, 14 Jul 2007) $
 */
public class MutablePartitionConfiguration extends PartitionConfiguration
{
    /**
     * Creates a new instance.
     */
    public MutablePartitionConfiguration()
    {
    }


    public void setId( String id )
    {
        super.setId( id );
    }


    public void setIndexedAttributes( Set<Object> indexedAttributes )
    {
        super.setIndexedAttributes( indexedAttributes );
    }


    public void setPartitionClassName( String partitionClassName )
    {
        super.setPartitionClassName( partitionClassName );
    }


    public void setContextEntry( Attributes rootEntry )
    {
        super.setContextEntry( rootEntry );
    }


    public void setSuffix( String suffix ) throws NamingException
    {
        super.setSuffix( suffix );
    }
    
    
    /**
     * Get's the entry cache size for this partition.
     */
    public void setCacheSize( int cacheSize )
    {
        super.setCacheSize( cacheSize );
    }
}
