/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.core.configuration;


/**
 * A mutable version of {@link AuthenticatorConfiguration}.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev: 556225 $, $Date: 2007-07-14 01:35:40 -0400 (Sat, 14 Jul 2007) $
 */
public class MutableAuthenticatorConfiguration extends AuthenticatorConfiguration
{
    /**
     * Creates a new instance.
     */
    public MutableAuthenticatorConfiguration()
    {
    }

    
    /**
     * Create and register an authenticator with its name
     * 
     * @param name The authenticator name
     * @param authenticator The authenticator to register
     */
    public MutableAuthenticatorConfiguration( String name, String authenticatorClassName )
    {
        super.setAuthenticatorClassName( name, authenticatorClassName );
    }

    
    /**
     * Register an authenticator
     * 
     * @param authenticator The authenticator to register
     */
    public void setAuthenticatorClassName( String authenticatorClassName )
    {
        super.setAuthenticatorClassName( authenticatorClassName );
    }

    
    public void setName( String name )
    {
        super.setName( name );
    }
}
