/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $
//  type=root


/**
 * Localized names for the "si" locale.
 */
public class LocalizedNamesImpl_si extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "LK",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "BL",
        "BQ",
        "BV",
        "CD",
        "CF",
        "CG",
        "CI",
        "CP",
        "CR",
        "CV",
        "CW",
        "CX",
        "CZ",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EA",
        "FM",
        "GG",
        "GP",
        "GS",
        "GT",
        "GU",
        "GW",
        "GY",
        "HR",
        "IC",
        "IM",
        "JE",
        "KG",
        "KH",
        "KI",
        "KM",
        "KN",
        "KY",
        "KZ",
        "LI",
        "LS",
        "LU",
        "MF",
        "MG",
        "MH",
        "MK",
        "MO",
        "MP",
        "MQ",
        "MW",
        "PM",
        "PR",
        "QO",
        "RE",
        "RW",
        "SB",
        "SC",
        "SH",
        "SJ",
        "SL",
        "SM",
        "SN",
        "SO",
        "SR",
        "SS",
        "ST",
        "SX",
        "SY",
        "SZ",
        "TA",
        "TD",
        "TF",
        "TG",
        "TJ",
        "TL",
        "TO",
        "TZ",
        "UG",
        "UM",
        "UY",
        "VA",
        "VC",
        "VE",
        "WF",
        "YT",
        "IE",
        "IS",
        "AW",
        "AZ",
        "AR",
        "AM",
        "AI",
        "AO",
        "AQ",
        "AG",
        "AD",
        "VI",
        "AS",
        "DZ",
        "AL",
        "AC",
        "AF",
        "EC",
        "IT",
        "ET",
        "IN",
        "ID",
        "IQ",
        "IR",
        "EG",
        "IL",
        "KP",
        "UZ",
        "AE",
        "US",
        "GB",
        "ER",
        "SV",
        "EE",
        "AT",
        "OM",
        "AX",
        "AU",
        "QA",
        "CA",
        "CM",
        "CU",
        "CK",
        "KW",
        "KE",
        "CC",
        "CO",
        "GD",
        "GL",
        "GR",
        "GA",
        "GM",
        "GN",
        "GH",
        "CL",
        "CN",
        "JP",
        "DE",
        "JM",
        "GI",
        "GE",
        "JO",
        "TC",
        "TT",
        "TN",
        "TV",
        "TK",
        "DK",
        "TH",
        "TW",
        "TM",
        "TR",
        "ZA",
        "KR",
        "NE",
        "NG",
        "NC",
        "NZ",
        "NR",
        "NA",
        "NI",
        "NU",
        "AN",
        "NL",
        "NP",
        "NO",
        "NF",
        "PS",
        "PW",
        "GF",
        "PF",
        "FR",
        "PK",
        "PA",
        "PG",
        "PY",
        "PN",
        "PH",
        "PT",
        "PE",
        "PL",
        "BD",
        "EH",
        "BF",
        "BM",
        "BG",
        "BS",
        "BH",
        "BR",
        "IO",
        "VG",
        "BB",
        "BI",
        "BJ",
        "BY",
        "BE",
        "BZ",
        "BO",
        "BW",
        "BA",
        "BN",
        "BT",
        "MR",
        "MV",
        "ML",
        "MY",
        "MM",
        "MU",
        "MX",
        "MN",
        "ME",
        "MS",
        "MC",
        "MA",
        "MD",
        "MZ",
        "MT",
        "UA",
        "EU",
        "YE",
        "RO",
        "RU",
        "LR",
        "LA",
        "LV",
        "LT",
        "LY",
        "LB",
        "VU",
        "VN",
        "LK",
        "LC",
        "GQ",
        "CY",
        "RS",
        "ES",
        "SK",
        "SI",
        "CH",
        "SE",
        "ZM",
        "WS",
        "SG",
        "ZW",
        "SD",
        "SA",
        "HU",
        "HT",
        "HM",
        "HK",
        "HN",
        "FO",
        "FI",
        "FJ",
        "FK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ලෝකය");
    namesMap.put("002", "අප්‍රිකාව");
    namesMap.put("003", "උතුරු ඇමෙරිකාව");
    namesMap.put("005", "දකුණු ඇමෙරිකාව");
    namesMap.put("009", "ඔෂනියාව");
    namesMap.put("011", "බටහිරදිග අප්‍රිකාව");
    namesMap.put("013", "මධ්‍යම ඇමෙරිකාව");
    namesMap.put("014", "පෙරදිග අප්‍රිකාව");
    namesMap.put("015", "උතුරුදිග අප්‍රිකාව");
    namesMap.put("017", "මධ්‍යම අප්‍රිකාව");
    namesMap.put("018", "දකුණුදිග අප්‍රිකාව");
    namesMap.put("021", "උතුරුදිග ඇමෙරිකාව");
    namesMap.put("029", "කැරීබියන්");
    namesMap.put("030", "නැගෙනහිර ආසියාව");
    namesMap.put("034", "දකුණු ආසියාව");
    namesMap.put("035", "අග්නිදිග ආසියාව");
    namesMap.put("039", "දකුණුදිග යුරෝපය");
    namesMap.put("053", "ඕස්ට්‍රේලියාව සහ නවසීලන්තය");
    namesMap.put("057", "මයික්‍රෝනීසියානු කළාපය");
    namesMap.put("061", "පොලිනීසියාව");
    namesMap.put("142", "ආසියාව");
    namesMap.put("143", "මධ්‍යම ආසියාව");
    namesMap.put("145", "බටහිර ආසියාව");
    namesMap.put("150", "යුරෝපය");
    namesMap.put("151", "නැගෙනහිර යුරෝපය");
    namesMap.put("154", "උතුරු යුරෝපය");
    namesMap.put("155", "බටහිර යුරෝපය");
    namesMap.put("419", "ලතින් ඇමෙරිකාව");
    namesMap.put("AC", "ඇසෙන්ෂන් දිවයින");
    namesMap.put("AD", "ඇන්ඩෝරාව");
    namesMap.put("AE", "එක්සත් අරාබි එමිර් රාජ්‍යය");
    namesMap.put("AF", "ඇෆ්ගනිස්ථානය");
    namesMap.put("AG", "ඇන්ටිගුවා සහ බාබියුඩා");
    namesMap.put("AI", "ඇන්ගුයිලාව");
    namesMap.put("AL", "ඇල්බේනියාව");
    namesMap.put("AM", "ආර්මේනියාව");
    namesMap.put("AN", "නෙදර්ලන්ත ඇන්ටිලීසිය");
    namesMap.put("AO", "ඇන්ගෝලාව");
    namesMap.put("AQ", "ඇන්ටාක්ටිකාව");
    namesMap.put("AR", "ආර්ජෙන්ටිනාව");
    namesMap.put("AS", "ඇමරිකානු සැමෝවාව");
    namesMap.put("AT", "ඔස්ට්‍රියාව");
    namesMap.put("AU", "ඕස්ට්‍රේලියාව");
    namesMap.put("AW", "අරුබාව");
    namesMap.put("AX", "ඕලන්ඩ් දූපත්");
    namesMap.put("AZ", "අසර්බයිජානය");
    namesMap.put("BA", "බොස්නියාව සහ හර්සගොවීනාව");
    namesMap.put("BB", "බාර්බඩෝස්");
    namesMap.put("BD", "බංගලිදේශය");
    namesMap.put("BE", "බෙල්ජියම");
    namesMap.put("BF", "බර්කිනා ෆාසෝ");
    namesMap.put("BG", "බල්ගේරියාව");
    namesMap.put("BH", "බහරේන්");
    namesMap.put("BI", "බුරුන්ඩි");
    namesMap.put("BJ", "බෙනින්");
    namesMap.put("BM", "බර්මියුඩා");
    namesMap.put("BN", "බෲනායි");
    namesMap.put("BO", "බොලීවියාව");
    namesMap.put("BR", "බ්‍රසීලය");
    namesMap.put("BS", "බහමාස්");
    namesMap.put("BT", "භූතානය");
    namesMap.put("BW", "බොස්ට්වානා");
    namesMap.put("BY", "බෙලරුස්");
    namesMap.put("BZ", "බෙලීස්");
    namesMap.put("CA", "කැනඩාව");
    namesMap.put("CC", "කොකෝස් දූපත්");
    namesMap.put("CH", "ස්විස්ටර්ලන්තය");
    namesMap.put("CK", "කුක් දූපත්");
    namesMap.put("CL", "චිලී");
    namesMap.put("CM", "කැමරූන්");
    namesMap.put("CN", "චීනය");
    namesMap.put("CO", "කොළොම්බියාව");
    namesMap.put("CU", "කියුබාව");
    namesMap.put("CY", "සයිප්‍රසය");
    namesMap.put("DE", "ජර්මනිය");
    namesMap.put("DK", "ඩෙන්මාර්කය");
    namesMap.put("DZ", "ඇල්ජීරියාව");
    namesMap.put("EC", "ඉක්වදෝරය");
    namesMap.put("EE", "එස්තෝනියාව");
    namesMap.put("EG", "ඊජිප්තුව");
    namesMap.put("EH", "බටහිර සහරාව");
    namesMap.put("ER", "එරිත්‍රියාව");
    namesMap.put("ES", "ස්පාඤ්ඤය");
    namesMap.put("ET", "ඉතියෝපියාව");
    namesMap.put("EU", "යුරෝපා සංගමය");
    namesMap.put("FI", "ෆින්ලන්තය");
    namesMap.put("FJ", "ෆීජී");
    namesMap.put("FK", "ෆෝක්ලන්ත දූපත්");
    namesMap.put("FO", "ෆැරෝ දූපත්");
    namesMap.put("FR", "ප්‍රංශය");
    namesMap.put("GA", "ගැබොන්");
    namesMap.put("GB", "එක්සත් රාජධානිය");
    namesMap.put("GD", "ග්‍රැනඩාව");
    namesMap.put("GE", "ජෝර්ජියාව");
    namesMap.put("GF", "ප්‍රංශ ගයනාව");
    namesMap.put("GH", "ඝානාව");
    namesMap.put("GI", "ජිබ්‍රෝල්ටාව");
    namesMap.put("GL", "ග්‍රීන්ලන්තය");
    namesMap.put("GM", "ගැම්බියාව");
    namesMap.put("GN", "ගිණියාව");
    namesMap.put("GQ", "සමක ගිනියාව");
    namesMap.put("GR", "ග්‍රීසිය");
    namesMap.put("HK", "හොංකොං චීන විශේෂ පරිපාලන කලාපය");
    namesMap.put("HM", "හාඩ් සහ මැක්ඩොනල්ඩ් දූපත්");
    namesMap.put("HN", "හොන්ඩුරාස්");
    namesMap.put("HT", "හයිටි");
    namesMap.put("HU", "හන්ගේරියාව");
    namesMap.put("ID", "ඉන්දුනීසියාව");
    namesMap.put("IE", "අයර්ලන්තය");
    namesMap.put("IL", "ඊශ්‍රායලය");
    namesMap.put("IN", "ඉන්දියාව");
    namesMap.put("IO", "බ්‍රිතාන්‍ය ඉන්දීය සාගර ප්‍රාන්තය");
    namesMap.put("IQ", "ඉරාකය");
    namesMap.put("IR", "ඉරානය");
    namesMap.put("IS", "අයිස්ලන්තය");
    namesMap.put("IT", "ඉතාලිය");
    namesMap.put("JM", "ජැමෙයිකාව");
    namesMap.put("JO", "ජෝර්දානය");
    namesMap.put("JP", "ජපානය");
    namesMap.put("KE", "කෙන්යාව");
    namesMap.put("KP", "උතුරු කොරියාව");
    namesMap.put("KR", "දකුණු කොරියාව");
    namesMap.put("KW", "කුවේටය");
    namesMap.put("LA", "ලාඕසය");
    namesMap.put("LB", "ලෙබනනය");
    namesMap.put("LC", "ශාන්ත ලුසියා");
    namesMap.put("LK", "ශ්‍රී ලංකාව");
    namesMap.put("LR", "ලයිබීරියාව");
    namesMap.put("LT", "ලිතුවේනියාව");
    namesMap.put("LV", "ලැට්වියාව");
    namesMap.put("LY", "ලිබියාව");
    namesMap.put("MA", "මොරොක්කෝව");
    namesMap.put("MC", "මොනාකෝව");
    namesMap.put("MD", "මොල්ඩෝවාව");
    namesMap.put("ME", "මොන්ඩිනීග්‍රෝ");
    namesMap.put("ML", "මාලි");
    namesMap.put("MM", "මියන්මාරය");
    namesMap.put("MN", "මොන්ගෝලියාව");
    namesMap.put("MR", "මාර්ටිනික්");
    namesMap.put("MS", "මොන්සෙරාට්");
    namesMap.put("MT", "මෝල්ටාව");
    namesMap.put("MU", "මුරුසිය");
    namesMap.put("MV", "මාල දිවයින");
    namesMap.put("MX", "මෙක්සිකෝව");
    namesMap.put("MY", "මැලේසියාව");
    namesMap.put("MZ", "මොසැම්බික්");
    namesMap.put("NA", "නැමීබියාව");
    namesMap.put("NC", "නව කැලිඩෝනියාව");
    namesMap.put("NE", "නයිජර්");
    namesMap.put("NF", "නෝෆෝක් දූපත");
    namesMap.put("NG", "නයිජීරියාව");
    namesMap.put("NI", "නිකරගුවාව");
    namesMap.put("NL", "නෙදර්ලන්තය");
    namesMap.put("NO", "නෝර්වේ");
    namesMap.put("NP", "නේපාලය");
    namesMap.put("NR", "නාවුරු");
    namesMap.put("NU", "නියූ");
    namesMap.put("NZ", "නවසීලන්තය");
    namesMap.put("OM", "ඕමානය");
    namesMap.put("PA", "පැනමා");
    namesMap.put("PE", "පේරු");
    namesMap.put("PF", "ප්‍රංශ පොලිනීසියාව");
    namesMap.put("PG", "පැපුවා නිව් ගිනියාව");
    namesMap.put("PH", "පිලිපීනය");
    namesMap.put("PK", "පාකිස්තානය");
    namesMap.put("PL", "පෝලන්තය");
    namesMap.put("PN", "පිට්කෙය්න් දූපත්");
    namesMap.put("PS", "පලස්තීනය");
    namesMap.put("PT", "පෘතුගාලය");
    namesMap.put("PW", "පලාවු");
    namesMap.put("PY", "පැරගුවේ");
    namesMap.put("QA", "කටාර්ය");
    namesMap.put("RO", "රුමේනියාව");
    namesMap.put("RS", "සර්බියාව");
    namesMap.put("RU", "රුසියාව");
    namesMap.put("SA", "සෞදි අරාබිය");
    namesMap.put("SD", "සූඩානය");
    namesMap.put("SE", "ස්වීඩනය");
    namesMap.put("SG", "සිංගප්පූරුව");
    namesMap.put("SI", "ස්ලෝවේනියාව");
    namesMap.put("SK", "ස්ලෝවැකියාව");
    namesMap.put("SV", "එල් සැල්වදෝරය");
    namesMap.put("TC", "ටර්ක්ස් සහ කයිකොස් දූපත්");
    namesMap.put("TH", "තායිලන්තය");
    namesMap.put("TK", "ටොකලාවු");
    namesMap.put("TM", "තුර්ක්මෙනිස්ථානය");
    namesMap.put("TN", "ටියුනීසියාව");
    namesMap.put("TR", "තුර්කිය");
    namesMap.put("TT", "ට්‍රිනිඩෑඩ් සහ ටොබැගෝ");
    namesMap.put("TV", "ටුවාලූ");
    namesMap.put("TW", "තායිවානය");
    namesMap.put("UA", "යුක්රේනය");
    namesMap.put("US", "එක්සත් ජනපදය");
    namesMap.put("UZ", "උස්බෙකිස්ථානය");
    namesMap.put("VG", "බ්‍රිතාන්‍ය වර්ජින් දූපත්");
    namesMap.put("VI", "ඇමරිකානු වර්ජින් දූපත්");
    namesMap.put("VN", "වියට්නාමය");
    namesMap.put("VU", "වනුවාටු");
    namesMap.put("WS", "සැමෝවා");
    namesMap.put("YE", "යේමනය");
    namesMap.put("ZA", "දකුණු අප්‍රිකාව");
    namesMap.put("ZM", "සැම්බියාව");
    namesMap.put("ZW", "සිම්බාබ්වේ");
    namesMap.put("ZZ", "හඳුනා නොගත් කළාපය");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ලෝකය",
        "002": "අප්‍රිකාව",
        "003": "උතුරු ඇමෙරිකාව",
        "005": "දකුණු ඇමෙරිකාව",
        "009": "ඔෂනියාව",
        "011": "බටහිරදිග අප්‍රිකාව",
        "013": "මධ්‍යම ඇමෙරිකාව",
        "014": "පෙරදිග අප්‍රිකාව",
        "015": "උතුරුදිග අප්‍රිකාව",
        "017": "මධ්‍යම අප්‍රිකාව",
        "018": "දකුණුදිග අප්‍රිකාව",
        "021": "උතුරුදිග ඇමෙරිකාව",
        "029": "කැරීබියන්",
        "030": "නැගෙනහිර ආසියාව",
        "034": "දකුණු ආසියාව",
        "035": "අග්නිදිග ආසියාව",
        "039": "දකුණුදිග යුරෝපය",
        "053": "ඕස්ට්‍රේලියාව සහ නවසීලන්තය",
        "057": "මයික්‍රෝනීසියානු කළාපය",
        "061": "පොලිනීසියාව",
        "142": "ආසියාව",
        "143": "මධ්‍යම ආසියාව",
        "145": "බටහිර ආසියාව",
        "150": "යුරෝපය",
        "151": "නැගෙනහිර යුරෝපය",
        "154": "උතුරු යුරෝපය",
        "155": "බටහිර යුරෝපය",
        "419": "ලතින් ඇමෙරිකාව",
        "AC": "ඇසෙන්ෂන් දිවයින",
        "AD": "ඇන්ඩෝරාව",
        "AE": "එක්සත් අරාබි එමිර් රාජ්‍යය",
        "AF": "ඇෆ්ගනිස්ථානය",
        "AG": "ඇන්ටිගුවා සහ බාබියුඩා",
        "AI": "ඇන්ගුයිලාව",
        "AL": "ඇල්බේනියාව",
        "AM": "ආර්මේනියාව",
        "AN": "නෙදර්ලන්ත ඇන්ටිලීසිය",
        "AO": "ඇන්ගෝලාව",
        "AQ": "ඇන්ටාක්ටිකාව",
        "AR": "ආර්ජෙන්ටිනාව",
        "AS": "ඇමරිකානු සැමෝවාව",
        "AT": "ඔස්ට්‍රියාව",
        "AU": "ඕස්ට්‍රේලියාව",
        "AW": "අරුබාව",
        "AX": "ඕලන්ඩ් දූපත්",
        "AZ": "අසර්බයිජානය",
        "BA": "බොස්නියාව සහ හර්සගොවීනාව",
        "BB": "බාර්බඩෝස්",
        "BD": "බංගලිදේශය",
        "BE": "බෙල්ජියම",
        "BF": "බර්කිනා ෆාසෝ",
        "BG": "බල්ගේරියාව",
        "BH": "බහරේන්",
        "BI": "බුරුන්ඩි",
        "BJ": "බෙනින්",
        "BM": "බර්මියුඩා",
        "BN": "බෲනායි",
        "BO": "බොලීවියාව",
        "BR": "බ්‍රසීලය",
        "BS": "බහමාස්",
        "BT": "භූතානය",
        "BW": "බොස්ට්වානා",
        "BY": "බෙලරුස්",
        "BZ": "බෙලීස්",
        "CA": "කැනඩාව",
        "CC": "කොකෝස් දූපත්",
        "CH": "ස්විස්ටර්ලන්තය",
        "CK": "කුක් දූපත්",
        "CL": "චිලී",
        "CM": "කැමරූන්",
        "CN": "චීනය",
        "CO": "කොළොම්බියාව",
        "CU": "කියුබාව",
        "CY": "සයිප්‍රසය",
        "DE": "ජර්මනිය",
        "DK": "ඩෙන්මාර්කය",
        "DZ": "ඇල්ජීරියාව",
        "EC": "ඉක්වදෝරය",
        "EE": "එස්තෝනියාව",
        "EG": "ඊජිප්තුව",
        "EH": "බටහිර සහරාව",
        "ER": "එරිත්‍රියාව",
        "ES": "ස්පාඤ්ඤය",
        "ET": "ඉතියෝපියාව",
        "EU": "යුරෝපා සංගමය",
        "FI": "ෆින්ලන්තය",
        "FJ": "ෆීජී",
        "FK": "ෆෝක්ලන්ත දූපත්",
        "FO": "ෆැරෝ දූපත්",
        "FR": "ප්‍රංශය",
        "GA": "ගැබොන්",
        "GB": "එක්සත් රාජධානිය",
        "GD": "ග්‍රැනඩාව",
        "GE": "ජෝර්ජියාව",
        "GF": "ප්‍රංශ ගයනාව",
        "GH": "ඝානාව",
        "GI": "ජිබ්‍රෝල්ටාව",
        "GL": "ග්‍රීන්ලන්තය",
        "GM": "ගැම්බියාව",
        "GN": "ගිණියාව",
        "GQ": "සමක ගිනියාව",
        "GR": "ග්‍රීසිය",
        "HK": "හොංකොං චීන විශේෂ පරිපාලන කලාපය",
        "HM": "හාඩ් සහ මැක්ඩොනල්ඩ් දූපත්",
        "HN": "හොන්ඩුරාස්",
        "HT": "හයිටි",
        "HU": "හන්ගේරියාව",
        "ID": "ඉන්දුනීසියාව",
        "IE": "අයර්ලන්තය",
        "IL": "ඊශ්‍රායලය",
        "IN": "ඉන්දියාව",
        "IO": "බ්‍රිතාන්‍ය ඉන්දීය සාගර ප්‍රාන්තය",
        "IQ": "ඉරාකය",
        "IR": "ඉරානය",
        "IS": "අයිස්ලන්තය",
        "IT": "ඉතාලිය",
        "JM": "ජැමෙයිකාව",
        "JO": "ජෝර්දානය",
        "JP": "ජපානය",
        "KE": "කෙන්යාව",
        "KP": "උතුරු කොරියාව",
        "KR": "දකුණු කොරියාව",
        "KW": "කුවේටය",
        "LA": "ලාඕසය",
        "LB": "ලෙබනනය",
        "LC": "ශාන්ත ලුසියා",
        "LK": "ශ්‍රී ලංකාව",
        "LR": "ලයිබීරියාව",
        "LT": "ලිතුවේනියාව",
        "LV": "ලැට්වියාව",
        "LY": "ලිබියාව",
        "MA": "මොරොක්කෝව",
        "MC": "මොනාකෝව",
        "MD": "මොල්ඩෝවාව",
        "ME": "මොන්ඩිනීග්‍රෝ",
        "ML": "මාලි",
        "MM": "මියන්මාරය",
        "MN": "මොන්ගෝලියාව",
        "MR": "මාර්ටිනික්",
        "MS": "මොන්සෙරාට්",
        "MT": "මෝල්ටාව",
        "MU": "මුරුසිය",
        "MV": "මාල දිවයින",
        "MX": "මෙක්සිකෝව",
        "MY": "මැලේසියාව",
        "MZ": "මොසැම්බික්",
        "NA": "නැමීබියාව",
        "NC": "නව කැලිඩෝනියාව",
        "NE": "නයිජර්",
        "NF": "නෝෆෝක් දූපත",
        "NG": "නයිජීරියාව",
        "NI": "නිකරගුවාව",
        "NL": "නෙදර්ලන්තය",
        "NO": "නෝර්වේ",
        "NP": "නේපාලය",
        "NR": "නාවුරු",
        "NU": "නියූ",
        "NZ": "නවසීලන්තය",
        "OM": "ඕමානය",
        "PA": "පැනමා",
        "PE": "පේරු",
        "PF": "ප්‍රංශ පොලිනීසියාව",
        "PG": "පැපුවා නිව් ගිනියාව",
        "PH": "පිලිපීනය",
        "PK": "පාකිස්තානය",
        "PL": "පෝලන්තය",
        "PN": "පිට්කෙය්න් දූපත්",
        "PS": "පලස්තීනය",
        "PT": "පෘතුගාලය",
        "PW": "පලාවු",
        "PY": "පැරගුවේ",
        "QA": "කටාර්ය",
        "RO": "රුමේනියාව",
        "RS": "සර්බියාව",
        "RU": "රුසියාව",
        "SA": "සෞදි අරාබිය",
        "SD": "සූඩානය",
        "SE": "ස්වීඩනය",
        "SG": "සිංගප්පූරුව",
        "SI": "ස්ලෝවේනියාව",
        "SK": "ස්ලෝවැකියාව",
        "SV": "එල් සැල්වදෝරය",
        "TC": "ටර්ක්ස් සහ කයිකොස් දූපත්",
        "TH": "තායිලන්තය",
        "TK": "ටොකලාවු",
        "TM": "තුර්ක්මෙනිස්ථානය",
        "TN": "ටියුනීසියාව",
        "TR": "තුර්කිය",
        "TT": "ට්‍රිනිඩෑඩ් සහ ටොබැගෝ",
        "TV": "ටුවාලූ",
        "TW": "තායිවානය",
        "UA": "යුක්රේනය",
        "US": "එක්සත් ජනපදය",
        "UZ": "උස්බෙකිස්ථානය",
        "VG": "බ්‍රිතාන්‍ය වර්ජින් දූපත්",
        "VI": "ඇමරිකානු වර්ජින් දූපත්",
        "VN": "වියට්නාමය",
        "VU": "වනුවාටු",
        "WS": "සැමෝවා",
        "YE": "යේමනය",
        "ZA": "දකුණු අප්‍රිකාව",
        "ZM": "සැම්බියාව",
        "ZW": "සිම්බාබ්වේ",
        "ZZ": "හඳුනා නොගත් කළාපය"
    };
  }-*/;
}
