/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.Maps;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoMap {
    private Map<Class<?>, XmlClass> m_map = Maps.newHashMap();

    public ClassInfoMap() {
    }

    public ClassInfoMap(List<XmlClass> classes) {
        for (XmlClass xmlClass : classes) {
            try {
                this.m_map.put(xmlClass.getSupportClass(), xmlClass);
            }
            catch (NoClassDefFoundError e) {
                Utils.log("[ClassInfoMap]", 1, "Unable to open class " + xmlClass.getName() + " - unable to resolve class reference " + e.getMessage());
                if (!xmlClass.loadClasses()) continue;
                throw e;
            }
        }
    }

    public void addClass(Class<?> cls) {
        this.m_map.put(cls, null);
    }

    public XmlClass getXmlClass(Class<?> cls) {
        return this.m_map.get(cls);
    }

    public void put(Class<?> cls, XmlClass xmlClass) {
        this.m_map.put(cls, xmlClass);
    }

    public Set<Class<?>> getClasses() {
        return this.m_map.keySet();
    }

    public int getSize() {
        return this.m_map.size();
    }
}

