/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.Calendar;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectoryTestCase;
import org.nuxeo.ecm.directory.sql.TestSQLDirectory;

public class TestSQLDirectoryWithTSVInit
extends SQLDirectoryTestCase {
    private static final String SCHEMA = "user";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployContrib("org.nuxeo.ecm.directory.sql.tests", "test-sql-directories-tsv-bundle.xml");
    }

    public static Session getSession() throws Exception {
        return TestSQLDirectoryWithTSVInit.getSession("userDirectory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntry() throws Exception {
        try (Session session = TestSQLDirectoryWithTSVInit.getSession();){
            DocumentModel dm = session.getEntry("AdministratorTSV");
            Assert.assertNotNull((Object)dm);
            Assert.assertEquals((Object)"AdministratorTSV", (Object)dm.getProperty(SCHEMA, "username"));
            Assert.assertEquals((Object)"AdministratorTSV", (Object)dm.getProperty(SCHEMA, "password"));
            Assert.assertEquals((Object)10L, (Object)dm.getProperty(SCHEMA, "intField"));
            TestSQLDirectory.assertCalendarEquals(TestSQLDirectory.getCalendar(1982, 3, 25, 16, 30, 47, 123), (Calendar)dm.getProperty(SCHEMA, "dateField"));
        }
    }
}

