/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryTestCase;
import org.nuxeo.runtime.api.Framework;

public class TestSQLDirectoryAutoIncrementId
extends SQLDirectoryTestCase {
    private static final String SCHEMA = "intIdSchema";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployContrib("org.nuxeo.ecm.directory.sql.tests", "autoincrementid-contrib.xml");
    }

    @Test
    public void testAutoIncrementId() throws Exception {
        DirectoryService service = (DirectoryService)Framework.getRuntime().getComponent(DirectoryService.NAME);
        Session session = service.open("testAutoIncrement");
        Assert.assertNotNull((Object)session);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", 42L);
        map.put("label", "foo");
        DocumentModel entry = session.createEntry(map);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)1L, (Object)entry.getProperty(SCHEMA, "id"));
        Assert.assertEquals((Object)"foo", (Object)entry.getProperty(SCHEMA, "label"));
        map.clear();
        map.put("label", "bar");
        DocumentModel entry2 = session.createEntry(map);
        Assert.assertNotNull((Object)entry2);
        Assert.assertEquals((Object)2L, (Object)entry2.getProperty(SCHEMA, "id"));
        Assert.assertEquals((Object)"bar", (Object)entry2.getProperty(SCHEMA, "label"));
    }
}

