/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectoryTestCase;
import org.nuxeo.ecm.directory.sql.filter.SQLBetweenFilter;

public class TestPagingComplexFilterDirectory
extends SQLDirectoryTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployContrib("org.nuxeo.ecm.directory.sql.tests", "pagingDirectory-contrib.xml");
    }

    public Session getSession() throws ClientException {
        return TestPagingComplexFilterDirectory.getSession("pagingDirectory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPaging() throws ClientException {
        try (Session session = this.getSession();){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("label", "Label");
            HashMap<String, String> order = new HashMap<String, String>();
            order.put("id", "ASC");
            DocumentModelList entries = session.query(filter, filter.keySet());
            Assert.assertEquals((long)12L, (long)entries.size());
            Assert.assertEquals((Object)"1", (Object)((DocumentModel)entries.get(0)).getId());
            entries = session.query(filter, filter.keySet(), order, false, 5, -1);
            Assert.assertEquals((long)5L, (long)entries.size());
            Assert.assertEquals((Object)"1", (Object)((DocumentModel)entries.get(0)).getId());
            entries = session.query(filter, filter.keySet(), order, false, 5, 1);
            Assert.assertEquals((long)5L, (long)entries.size());
            Assert.assertEquals((Object)"2", (Object)((DocumentModel)entries.get(0)).getId());
            entries = session.query(filter, filter.keySet(), order, false, 5, 11);
            Assert.assertEquals((long)1L, (long)entries.size());
            Assert.assertEquals((Object)"12", (Object)((DocumentModel)entries.get(0)).getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComplexFilter() throws ClientException {
        try (Session session = this.getSession();){
            GregorianCalendar d121110 = new DateTime(2012, 11, 10, 0, 0, 0, 0).toGregorianCalendar();
            GregorianCalendar d121211 = new DateTime(2012, 12, 11, 0, 0, 0, 0).toGregorianCalendar();
            GregorianCalendar d121224 = new DateTime(2012, 12, 24, 0, 0, 0, 0).toGregorianCalendar();
            SQLBetweenFilter betweenFilter = new SQLBetweenFilter((Calendar)d121110, (Calendar)d121224);
            HashMap<String, Object> filter = new HashMap<String, Object>();
            filter.put("date", betweenFilter);
            DocumentModelList entries = session.query(filter);
            Assert.assertEquals((long)12L, (long)entries.size());
            betweenFilter = new SQLBetweenFilter((Calendar)d121211, (Calendar)d121224);
            filter.put("date", betweenFilter);
            entries = session.query(filter);
            Assert.assertEquals((long)2L, (long)entries.size());
            filter.put("type", "something");
            entries = session.query(filter);
            Assert.assertEquals((long)1L, (long)entries.size());
        }
    }
}

