/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.directory.DirectoryServiceImpl;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryTestCase;
import org.nuxeo.runtime.api.Framework;

public class TestFilterDirectories
extends SQLDirectoryTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployContrib("org.nuxeo.ecm.directory.sql.tests", "filterDirectoryContrib.xml");
    }

    @Test
    public void testFilterDirectory() throws Exception {
        DirectoryServiceImpl dirServiceImpl = (DirectoryServiceImpl)Framework.getRuntime().getComponent(DirectoryService.NAME);
        Session unfiltredSession = dirServiceImpl.open("unfiltredTestDirectory");
        Assert.assertNotNull((Object)unfiltredSession);
        Assert.assertEquals((long)5L, (long)unfiltredSession.getEntries().size());
        Assert.assertNotNull((Object)unfiltredSession.getEntry("1"));
        Assert.assertNotNull((Object)unfiltredSession.getEntry("2"));
        Assert.assertNotNull((Object)unfiltredSession.getEntry("5"));
        HashMap<String, String> queryFilter = new HashMap<String, String>();
        queryFilter.put("lang", "en");
        Assert.assertEquals((long)2L, (long)unfiltredSession.query(queryFilter).size());
        Session filtredSession = dirServiceImpl.open("filtredTestDirectory");
        Assert.assertNotNull((Object)filtredSession);
        Assert.assertEquals((long)2L, (long)filtredSession.getEntries().size());
        Assert.assertNotNull((Object)filtredSession.getEntry("1"));
        Assert.assertNull((Object)filtredSession.getEntry("2"));
        Assert.assertNull((Object)filtredSession.getEntry("5"));
        Assert.assertEquals((long)1L, (long)filtredSession.query(queryFilter).size());
    }
}

