/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLDirectoryTestCase;

public class TestDescriptorOverride
extends SQLDirectoryTestCase {
    @Test
    public void testOverride() throws Exception {
        Directory dir = TestDescriptorOverride.getDirectory("userDirectory");
        SQLDirectory sqlDir = (SQLDirectory)dir;
        SQLDirectoryDescriptor config = sqlDir.getConfig();
        Assert.assertEquals((Object)"always", (Object)config.getCreateTablePolicy());
        Assert.assertEquals((long)100L, (long)config.getQuerySizeLimit());
        Assert.assertFalse((boolean)config.isAutoincrementIdField());
        Assert.assertTrue((boolean)config.isComputeMultiTenantId());
        Assert.assertNull((Object)config.cacheEntryName);
        Assert.assertNull((Object)config.cacheEntryWithoutReferencesName);
        Assert.assertEquals((Object)"test-users.csv", (Object)config.getDataFileName());
        this.deployContrib("org.nuxeo.ecm.directory.sql.tests", "test-sql-directories-override-bundle.xml");
        dir = TestDescriptorOverride.getDirectory("userDirectory");
        sqlDir = (SQLDirectory)dir;
        config = sqlDir.getConfig();
        Assert.assertEquals((Object)"never", (Object)config.getCreateTablePolicy());
        Assert.assertEquals((long)123L, (long)config.getQuerySizeLimit());
        Assert.assertTrue((boolean)config.isAutoincrementIdField());
        Assert.assertFalse((boolean)config.isComputeMultiTenantId());
        Assert.assertEquals((Object)"override-entry-cache", (Object)config.cacheEntryName);
        Assert.assertEquals((Object)"override-entry-cache-wo-ref", (Object)config.cacheEntryWithoutReferencesName);
        Assert.assertEquals((Object)"test-users.csv", (Object)config.getDataFileName());
        Assert.assertEquals((long)1L, (long)config.getTableReferences().length);
    }
}

