/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Named;
import javax.security.auth.login.LoginException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.ecm.platform.login.test.ClientLoginFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class, ClientLoginFeature.class})
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:test-sql-directories-schema-override.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-security.xml"})
public class TestContribSQLDirectorySecurity {
    @Inject
    ClientLoginFeature dummyLogin;
    @Inject
    @Named(value="userDirectory")
    Directory userDir;
    @Inject
    @Named(value="groupDirectory")
    Directory groupDir;
    Session userDirSession;
    Session groupDirSession;
    public static final String SUPER_USER = "superUser";
    public static final String READER_USER = "readerUser";

    @Before
    public void setUp() {
        this.userDirSession = this.userDir.getSession();
        this.groupDirSession = this.groupDir.getSession();
    }

    @After
    public void tearDown() throws Exception {
        this.userDirSession.close();
        this.groupDirSession.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cantCreateEntry() throws LoginException {
        this.dummyLogin.loginAs(READER_USER);
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("username", "user_0");
            map.put("password", "pass_0");
            map.put("intField", 5L);
            map.put("groups", Arrays.asList("members", "administrators"));
            DocumentModel entry = this.userDirSession.createEntry(map);
            Assert.assertNull((Object)entry);
            entry = this.userDirSession.getEntry("user_0");
            Assert.assertNull((Object)entry);
        }
        finally {
            this.dummyLogin.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canCreateEntry() throws Exception {
        this.dummyLogin.loginAs(SUPER_USER);
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("username", "user_0");
            map.put("password", "pass_0");
            map.put("intField", 5L);
            map.put("groups", Arrays.asList("members", "administrators"));
            DocumentModel entry = this.userDirSession.createEntry(map);
            Assert.assertNotNull((Object)entry);
            entry = this.userDirSession.getEntry("user_0");
            Assert.assertNotNull((Object)entry);
        }
        finally {
            this.dummyLogin.logout();
        }
    }

    @Test
    public void cantGetEntry() throws LoginException {
        this.dummyLogin.loginAs("aUser");
        DocumentModel entry = this.userDirSession.getEntry("user_1");
        Assert.assertNull((Object)entry);
        this.dummyLogin.logout();
    }

    @Test
    public void canGetEntry() throws LoginException {
        this.dummyLogin.loginAs(READER_USER);
        DocumentModel entry = this.userDirSession.getEntry("user_1");
        Assert.assertNotNull((Object)entry);
        this.dummyLogin.logout();
    }

    @Test
    public void cantSearch() throws LoginException {
        this.dummyLogin.loginAs("aUser");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", "user_3");
        DocumentModelList results = this.userDirSession.query(map);
        Assert.assertEquals((long)0L, (long)results.size());
        this.dummyLogin.logout();
    }

    @Test
    public void canSearch() throws LoginException {
        this.dummyLogin.loginAs(SUPER_USER);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", "user_3");
        DocumentModelList results = this.userDirSession.query(map);
        Assert.assertEquals((long)1L, (long)results.size());
        this.dummyLogin.logout();
    }

    @Test
    public void groupCanCreateAndGetEntry() throws Exception {
        this.dummyLogin.loginAs("aUserEveryone");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("groupname", "newGroup");
        DocumentModel entry = this.groupDirSession.createEntry(map);
        Assert.assertNotNull((Object)entry);
        entry = this.groupDirSession.getEntry("newGroup");
        Assert.assertNotNull((Object)entry);
        this.dummyLogin.logout();
    }
}

