/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import org.eclipse.jdt.internal.core.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.redis.RedisFeature;
import org.nuxeo.ecm.directory.DirectoryCache;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.TestSQLDirectory;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

public class TestCachedSQLDirectory
extends TestSQLDirectory {
    protected static final String CACHE_CONTRIB = "sql-directory-cache-config.xml";
    protected static final String REDIS_CACHE_CONFIG = "sql-directory-redis-cache-config.xml";
    protected static final String ENTRY_CACHE_NAME = "sql-entry-cache";
    protected static final String ENTRY_CACHE_WITHOUT_REFERENCES_NAME = "sql-entry-cache-without-references";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.deployBundle("org.nuxeo.ecm.core.cache");
        if (RedisFeature.setup((RuntimeHarness)this)) {
            this.deployTestContrib("org.nuxeo.ecm.directory.sql.tests", REDIS_CACHE_CONFIG);
        } else {
            this.deployTestContrib("org.nuxeo.ecm.directory.sql.tests", CACHE_CONTRIB);
        }
        this.fireFrameworkStarted();
        SQLDirectory dir = TestCachedSQLDirectory.getSQLDirectory();
        DirectoryCache cache = dir.getCache();
        cache.setEntryCacheName(ENTRY_CACHE_NAME);
        cache.setEntryCacheWithoutReferencesName(ENTRY_CACHE_WITHOUT_REFERENCES_NAME);
    }

    @Test
    public void testGetFromCache() throws DirectoryException, Exception {
        Session sqlSession = TestCachedSQLDirectory.getSQLDirectory().getSession();
        DocumentModel entry = sqlSession.getEntry("user_1");
        Assert.isNotNull((Object)entry);
        entry = sqlSession.getEntry("user_1");
        Assert.isNotNull((Object)entry);
    }
}

