/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.ecm.core.test.DefaultRepositoryInit;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.login.test.ClientLoginFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Features(value={ClientLoginFeature.class})
@RepositoryConfig(init=DefaultRepositoryInit.class, cleanup=Granularity.METHOD)
@Deploy(value={"org.nuxeo.ecm.directory.api", "org.nuxeo.ecm.directory", "org.nuxeo.ecm.core.schema", "org.nuxeo.ecm.directory.types.contrib", "org.nuxeo.ecm.directory.sql"})
public class SQLDirectoryFeature
extends SimpleFeature {
    public static final String USER_DIRECTORY_NAME = "userDirectory";
    public static final String GROUP_DIRECTORY_NAME = "groupDirectory";
    @Inject
    DirectoryService directoryService;
    protected final Map<Directory, Set<String>> savedContext = new HashMap<Directory, Set<String>>();

    public void configure(FeaturesRunner runner, Binder binder) {
        this.bindDirectory(binder, USER_DIRECTORY_NAME);
        this.bindDirectory(binder, GROUP_DIRECTORY_NAME);
    }

    protected void bindDirectory(Binder binder, final String name) {
        binder.bind(Directory.class).annotatedWith((Annotation)Names.named((String)name)).toProvider((Provider)new Provider<Directory>(){

            public Directory get() {
                return ((DirectoryService)Framework.getService(DirectoryService.class)).getDirectory(name);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        for (Directory dir : ((DirectoryService)Framework.getService(DirectoryService.class)).getDirectories()) {
            try (Session session = dir.getSession();){
                String field = session.getIdField();
                Map filter = Collections.emptyMap();
                this.savedContext.put(dir, new HashSet(session.getProjection(filter, field)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTeardown(FeaturesRunner runner) throws Exception {
        for (Map.Entry<Directory, Set<String>> each : this.savedContext.entrySet()) {
            Directory directory = each.getKey();
            Set<String> projection = each.getValue();
            try (Session session = directory.getSession();){
                String field = session.getIdField();
                Map filter = Collections.emptyMap();
                for (String id : session.getProjection(filter, field)) {
                    if (projection.contains(id)) continue;
                    session.deleteEntry(id);
                }
            }
        }
    }
}

