/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.memory.MemoryDirectory;
import org.nuxeo.ecm.directory.service.MockMemoryDirectoryDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class MockMemoryDirectoryFactory
extends DefaultComponent
implements DirectoryFactory {
    protected Map<String, MockMemoryDirectoryDescriptor> reg = new HashMap<String, MockMemoryDirectoryDescriptor>();

    public String getName() {
        return "org.nuxeo.ecm.directory.service.MockMemoryDirectoryFactory";
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        MockMemoryDirectoryDescriptor desc = (MockMemoryDirectoryDescriptor)contribution;
        String directoryName = desc.name;
        this.reg.put(directoryName, desc);
        try {
            DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
            directoryService.registerDirectory(directoryName, (DirectoryFactory)this);
        }
        catch (Exception e) {
            throw new DirectoryException("Error in Directory Service lookup", (Throwable)e);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        String directoryName = ((MockMemoryDirectoryDescriptor)contribution).name;
        this.reg.remove(directoryName);
        try {
            DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
            if (directoryService != null) {
                directoryService.unregisterDirectory(directoryName, (DirectoryFactory)this);
            }
        }
        catch (Exception e) {
            throw new DirectoryException("Error in Directory Service lookup", (Throwable)e);
        }
    }

    public Directory getDirectory(String name) {
        if (this.reg.containsKey(name)) {
            return new MemoryDirectory(name, null, null, "uid", "foo");
        }
        return null;
    }

    public void shutdown() {
    }

    public List<Directory> getDirectories() {
        throw new NotImplementedException();
    }
}

