/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.AbstractType;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.FieldImpl;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeException;

public class ComplexTypeImpl
extends AbstractType
implements ComplexType {
    private static final long serialVersionUID = 1L;
    protected final Map<QName, Field> fields = new HashMap<QName, Field>();
    protected volatile Map<String, Field> fieldsByName = new HashMap<String, Field>();
    protected final Namespace ns;

    public ComplexTypeImpl(ComplexType superType, String schema, String name, Namespace ns) {
        super(superType, schema, name);
        this.ns = ns;
    }

    public ComplexTypeImpl(ComplexType superType, String schema, String name) {
        this(superType, schema, name, Namespace.DEFAULT_NS);
    }

    protected void addField(Field field) {
        QName name = field.getName();
        this.fields.put(name, field);
        this.fieldsByName.put(name.getLocalName(), field);
        this.fieldsByName.put(name.getPrefixedName(), field);
    }

    @Override
    public Field addField(String name, Type type, String defaultValue, int flags) {
        QName qname = QName.valueOf(name, this.ns.prefix);
        FieldImpl field = new FieldImpl(qname, this, type, defaultValue, flags);
        this.addField(field);
        return field;
    }

    @Override
    public Namespace getNamespace() {
        return this.ns;
    }

    @Override
    public Field getField(String name) {
        return this.fieldsByName.get(name);
    }

    @Override
    public Field getField(QName name) {
        return this.fields.get(name);
    }

    @Override
    public Collection<Field> getFields() {
        return this.fields.values();
    }

    @Override
    public int getFieldsCount() {
        return this.fields.size();
    }

    @Override
    public boolean hasField(String name) {
        return this.fieldsByName.containsKey(name);
    }

    @Override
    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    @Override
    public boolean isComplexType() {
        return true;
    }

    @Override
    public boolean validate(Object object) throws TypeException {
        if (object == null) {
            return true;
        }
        if (object instanceof Map) {
            return this.validateMap((Map)object);
        }
        return false;
    }

    protected boolean validateMap(Map<Object, Object> map) {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.name + ')';
    }

    @Override
    public Map<String, Object> newInstance() {
        if (TypeConstants.isContentType(this)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : this.fields.values()) {
            Type type = field.getType();
            Object value = type.isComplexType() ? type.newInstance() : (type.isListType() ? new ArrayList() : field.getDefaultValue());
            map.put(field.getName().getLocalName(), value);
        }
        return map;
    }

    @Override
    public Object convert(Object object) throws TypeException {
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                String key = entry.getKey().toString();
                Field field = this.getField(key);
                if (field == null) {
                    throw new IllegalArgumentException("Field " + key + " is not defined for the complex type " + this.getName());
                }
                entry.setValue(field.getType().convert(entry.getValue()));
            }
            return object;
        }
        throw new TypeException("Incompatible object: " + object.getClass() + " for type " + this);
    }

    public static String canonicalXPath(String xpath) {
        while (xpath.length() > 0 && xpath.charAt(0) == '/') {
            xpath = xpath.substring(1);
        }
        if (xpath.indexOf(91) == -1) {
            return xpath;
        }
        return xpath.replaceAll("[^/\\[\\]]+\\[(\\d+|\\*)\\]", "$1");
    }
}

