/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XmlString;
import com.sun.xml.xsom.impl.RestrictionSimpleTypeImpl;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManagerImpl;
import org.nuxeo.ecm.core.schema.XSDTypes;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.Constraint;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.ListTypeImpl;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SchemaImpl;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeBindingException;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.ecm.core.schema.types.constraints.EnumConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.StringLengthConstraint;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSDLoader {
    private static final Log log = LogFactory.getLog(XSDLoader.class);
    private static final String ANONYMOUS_TYPE_SUFFIX = "#anonymousType";
    private static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    protected final SchemaManagerImpl schemaManager;
    protected List<String> referencedXSD = new ArrayList<String>();
    protected boolean collectReferencedXSD = false;
    protected SchemaBindingDescriptor sd;

    public XSDLoader(SchemaManagerImpl schemaManager) {
        this.schemaManager = schemaManager;
    }

    public XSDLoader(SchemaManagerImpl schemaManager, SchemaBindingDescriptor sd) {
        this.schemaManager = schemaManager;
        this.sd = sd;
    }

    public XSDLoader(SchemaManagerImpl schemaManager, boolean collectReferencedXSD) {
        this.schemaManager = schemaManager;
        this.collectReferencedXSD = collectReferencedXSD;
    }

    protected Schema getSchema(String name) {
        return this.schemaManager.getSchemaInternal(name);
    }

    protected void registerSchema(Schema schema) {
        this.schemaManager.registerSchema(schema);
    }

    protected Type getType(String name) {
        return this.schemaManager.getType(name);
    }

    protected XSOMParser getParser() {
        XSOMParser parser = new XSOMParser();
        SchemaErrorHandler errorHandler = new SchemaErrorHandler();
        parser.setErrorHandler((ErrorHandler)errorHandler);
        if (this.sd != null) {
            parser.setEntityResolver((EntityResolver)new NXSchemaResolver(this.schemaManager, this.sd));
        }
        return parser;
    }

    public Schema loadSchema(String name, String prefix, File file, boolean override) throws SAXException, IOException, TypeException {
        return this.loadSchema(name, prefix, file, override, null);
    }

    public Schema loadSchema(String name, String prefix, File file, boolean override, String xsdElement) throws SAXException, IOException, TypeException {
        XSOMParser parser = this.getParser();
        String systemId = file.toURI().toURL().toExternalForm();
        if (file.getPath().startsWith("\\\\")) {
            systemId = systemId.replace("file://", "file:////");
        }
        parser.parse(systemId);
        XSSchemaSet xsSchemas = parser.getResult();
        if (this.collectReferencedXSD) {
            this.collectReferencedXSD(xsSchemas);
        }
        return this.loadSchema(name, prefix, xsSchemas, override, xsdElement);
    }

    protected void collectReferencedXSD(XSSchemaSet xsSchemas) {
        Collection schemas = xsSchemas.getSchemas();
        String ns = null;
        for (XSSchema s : schemas) {
            String filePath;
            String systemId;
            ns = s.getTargetNamespace();
            if (ns.length() <= 0 || ns.equals(NS_XSD) || (systemId = s.getLocator().getSystemId()) == null || !systemId.startsWith("file:/") || this.referencedXSD.contains(filePath = systemId.substring(6))) continue;
            this.referencedXSD.add(filePath);
        }
    }

    public Schema loadSchema(String name, String prefix, URL url, String xsdElement) throws SAXException, TypeException {
        XSOMParser parser = this.getParser();
        parser.parse(url);
        XSSchemaSet xsSchemas = parser.getResult();
        return this.loadSchema(name, prefix, xsSchemas, false, xsdElement);
    }

    public Schema loadSchema(String name, String prefix, URL url) throws SAXException, TypeException {
        return this.loadSchema(name, prefix, url, null);
    }

    protected Schema loadSchema(String name, String prefix, XSSchemaSet schemaSet, boolean override, String xsdElement) throws SAXException, TypeException {
        if (schemaSet == null) {
            return null;
        }
        Collection schemas = schemaSet.getSchemas();
        XSSchema schema = null;
        String ns = null;
        for (XSSchema s : schemas) {
            ns = s.getTargetNamespace();
            if (ns.length() <= 0 || ns.equals(NS_XSD)) continue;
            schema = s;
            break;
        }
        if (schema == null) {
            return null;
        }
        Schema ecmSchema = this.getSchema(name);
        if (ecmSchema != null) {
            log.info((Object)("Schema " + ns + " is already registered"));
            if (!override) {
                log.debug((Object)("Schema " + ns + " will not be overridden"));
                return ecmSchema;
            }
        }
        ecmSchema = new SchemaImpl(name, new Namespace(ns, prefix));
        Collection elements = schema.getElementDecls().values();
        for (XSElementDecl el : elements) {
            Type ecmType = this.loadType(ecmSchema, el.getType(), el.getName());
            if (ecmType != null) {
                XSDLoader.createField((ComplexType)ecmSchema, el, ecmType);
                continue;
            }
            log.warn((Object)("Failed to load field " + el.getName() + " : " + el.getType()));
        }
        Collection attributes = schema.getAttributeDecls().values();
        for (XSAttributeDecl att : attributes) {
            Type ecmType = this.loadType(ecmSchema, (XSType)att.getType(), att.getName());
            if (ecmType != null) {
                XSDLoader.createField((ComplexType)ecmSchema, att, ecmType);
                continue;
            }
            log.warn((Object)("Failed to load field from attribute " + att.getName() + " : " + att.getType()));
        }
        if (xsdElement != null) {
            Field singleComplexField = ecmSchema.getField(xsdElement);
            if (singleComplexField == null) {
                log.warn((Object)("Unable to find element " + xsdElement + " to rebase schema " + name));
            } else if (singleComplexField.getType().isComplexType()) {
                ComplexType singleComplexFieldType = (ComplexType)singleComplexField.getType();
                ecmSchema = new SchemaImpl(singleComplexFieldType, name, new Namespace(ns, prefix));
            } else {
                log.warn((Object)("can not rebase schema " + name + " on " + xsdElement + " that is not a complex type"));
            }
        }
        this.registerSchema(ecmSchema);
        return ecmSchema;
    }

    protected Type loadType(Schema schema, XSType type, String fieldName) throws TypeBindingException {
        Type ecmType;
        String name;
        if (type.getName() == null || type.isLocal()) {
            name = XSDLoader.getAnonymousTypeName(type, fieldName);
            if (name == null) {
                log.warn((Object)"Unable to load type - no name found");
                return null;
            }
        } else {
            name = type.getName();
        }
        if ((ecmType = this.getType(name)) != null) {
            return ecmType;
        }
        ecmType = schema.getType(name);
        if (ecmType != null) {
            return ecmType;
        }
        if (type.getTargetNamespace().equals(NS_XSD)) {
            ecmType = XSDTypes.getType(name);
            if (ecmType == null) {
                log.warn((Object)("Cannot use unknown XSD type: " + name));
            }
            return ecmType;
        }
        ecmType = type.isSimpleType() ? (type instanceof XSListSimpleType ? this.loadListType(schema, (XSListSimpleType)type) : this.loadSimpleType(schema, type, fieldName)) : this.loadComplexType(schema, name, (XSType)type.asComplexType());
        if (ecmType != null) {
            schema.registerType(ecmType);
        } else {
            log.warn((Object)("loadType for " + fieldName + " of " + type + " returns null"));
        }
        return ecmType;
    }

    protected Type loadComplexType(Schema schema, String name, XSType type) throws TypeBindingException {
        Type ret;
        XSComplexType xsct;
        XSContentType content;
        XSType baseType = type.getBaseType();
        ComplexType superType = null;
        if (baseType.getBaseType() != baseType) {
            if (baseType.isComplexType()) {
                superType = (ComplexType)this.loadType(schema, baseType, name);
            } else {
                log.warn((Object)"Complex type has a non complex type super type???");
            }
        }
        if ((content = (xsct = type.asComplexType()).getExplicitContent()) == null) {
            content = xsct.getContentType();
        }
        if ((ret = this.createComplexType(schema, superType, name, content, xsct.isAbstract())) != null && ret instanceof ComplexType) {
            this.loadAttributes(schema, xsct, (ComplexType)ret);
        }
        return ret;
    }

    protected void loadAttributes(Schema schema, XSComplexType xsct, ComplexType ct) throws TypeBindingException {
        Collection attrs = xsct.getAttributeUses();
        for (XSAttributeUse attr : attrs) {
            XSAttributeDecl at = attr.getDecl();
            Type fieldType = this.loadType(schema, (XSType)at.getType(), at.getName());
            if (fieldType == null) {
                throw new TypeBindingException("Cannot add type for '" + at.getName() + "'");
            }
            XSDLoader.createField(ct, at, fieldType);
        }
    }

    protected SimpleType loadSimpleType(Schema schema, XSType type, String fieldName) throws TypeBindingException {
        String name = type.getName();
        if (name == null) {
            name = fieldName + ANONYMOUS_TYPE_SUFFIX;
        }
        XSType baseType = type.getBaseType();
        SimpleType superType = null;
        if (baseType != type) {
            superType = (SimpleType)this.loadType(schema, baseType, fieldName);
        }
        SimpleTypeImpl simpleType = new SimpleTypeImpl(superType, schema.getName(), name);
        if (type instanceof RestrictionSimpleTypeImpl) {
            List enumFacets;
            Constraint constraint;
            RestrictionSimpleTypeImpl restrictionType = (RestrictionSimpleTypeImpl)type;
            ArrayList<StringLengthConstraint> constraints = new ArrayList<StringLengthConstraint>();
            XSFacet maxLength = restrictionType.getFacet("maxLength");
            if (maxLength != null) {
                int min = 0;
                int max = Integer.parseInt(maxLength.getValue().toString());
                constraint = new StringLengthConstraint(min, max);
                constraints.add((StringLengthConstraint)constraint);
            }
            if ((enumFacets = restrictionType.getFacets("enumeration")) != null && enumFacets.size() > 0) {
                ArrayList<String> enumValues = new ArrayList<String>();
                for (XSFacet enumFacet : enumFacets) {
                    enumValues.add(enumFacet.getValue().toString());
                }
                constraint = new EnumConstraint(enumValues);
                constraints.add((StringLengthConstraint)constraint);
            }
            simpleType.setConstraints(constraints.toArray(new Constraint[0]));
        }
        return simpleType;
    }

    protected ListType loadListType(Schema schema, XSListSimpleType type) {
        String name = type.getName();
        if (name == null) {
            return null;
        }
        XSSimpleType xsItemType = type.getItemType();
        Type itemType = xsItemType.getTargetNamespace().equals(NS_XSD) ? XSDTypes.getType(xsItemType.getName()) : this.getType(xsItemType.getName());
        if (itemType == null) {
            log.error((Object)"list item type was not defined -> you should define first the item type");
            return null;
        }
        return new ListTypeImpl(schema.getName(), name, itemType);
    }

    protected Type createComplexType(Schema schema, ComplexType superType, String name, XSContentType content, boolean abstractType) throws TypeBindingException {
        ComplexTypeImpl ct = new ComplexTypeImpl(superType, schema.getName(), name);
        schema.registerType(ct);
        XSParticle particle = content.asParticle();
        if (particle == null) {
            return ct;
        }
        XSTerm term = particle.getTerm();
        XSModelGroup mg = term.asModelGroup();
        return this.processModelGroup(schema, superType, name, ct, mg, abstractType);
    }

    protected Type createFakeComplexType(Schema schema, ComplexType superType, String name, XSModelGroup mg) throws TypeBindingException {
        ComplexTypeImpl ct = new ComplexTypeImpl(superType, schema.getName(), name);
        schema.registerType(ct);
        return this.processModelGroup(schema, superType, name, ct, mg, false);
    }

    protected Type processModelGroup(Schema schema, ComplexType superType, String name, ComplexType ct, XSModelGroup mg, boolean abstractType) throws TypeBindingException {
        if (mg == null) {
            throw new TypeBindingException("unsupported complex type");
        }
        XSParticle[] group = mg.getChildren();
        if (group.length == 0) {
            return null;
        }
        if (group.length == 1 && superType == null && group[0].isRepeated() && !abstractType) {
            return this.createListType(schema, name, group[0]);
        }
        for (XSParticle child : group) {
            String fieldName;
            ListType listType;
            XSTerm term = child.getTerm();
            XSElementDecl element = term.asElementDecl();
            int maxOccur = child.getMaxOccurs();
            if (element == null) {
                if (maxOccur < 0 || maxOccur > 1) {
                    Type fakeType = this.createFakeComplexType(schema, superType, name + "#anonymousListItem", term.asModelGroup());
                    listType = XSDLoader.createListType(schema, name + "#anonymousListType", fakeType, 0, maxOccur);
                    fieldName = ct.getName() + "#anonymousList";
                    ct.addField(fieldName, listType, null, 0);
                    continue;
                }
                this.processModelGroup(schema, superType, name, ct, term.asModelGroup(), abstractType);
                continue;
            }
            if (maxOccur < 0 || maxOccur > 1) {
                Type fieldType = this.loadType(schema, element.getType(), element.getName());
                if (fieldType == null) continue;
                listType = XSDLoader.createListType(schema, element.getName() + "#anonymousListType", fieldType, 0, maxOccur);
                fieldName = element.getName();
                ct.addField(fieldName, listType, null, 0);
                continue;
            }
            this.loadComplexTypeElement(schema, ct, element);
        }
        if (superType != null && superType.isComplexType()) {
            for (Field parentField : superType.getFields()) {
                ct.addField(parentField.getName().getLocalName(), parentField.getType(), (String)parentField.getDefaultValue(), 0);
            }
        }
        return ct;
    }

    protected ListType createListType(Schema schema, String name, XSParticle particle) throws TypeBindingException {
        Type type;
        XSElementDecl element = particle.getTerm().asElementDecl();
        if (element == null) {
            log.warn((Object)("Ignoring " + name + " unsupported list type"));
            return null;
        }
        XmlString dv = element.getDefaultValue();
        String defValue = null;
        if (dv != null) {
            defValue = dv.value;
        }
        if ((type = this.loadType(schema, element.getType(), element.getName())) == null) {
            log.warn((Object)("Unable to find type for " + element.getName()));
            return null;
        }
        return new ListTypeImpl(schema.getName(), name, type, element.getName(), defValue, particle.getMinOccurs(), particle.getMaxOccurs());
    }

    protected static ListType createListType(Schema schema, String name, Type itemType, int min, int max) throws TypeBindingException {
        String elementName = name + "#item";
        return new ListTypeImpl(schema.getName(), name, itemType, elementName, null, min, max);
    }

    protected void loadComplexTypeElement(Schema schema, ComplexType type, XSElementDecl element) throws TypeBindingException {
        XSType elementType = element.getType();
        Type fieldType = this.loadType(schema, elementType, element.getName());
        if (fieldType != null) {
            XSDLoader.createField(type, element, fieldType);
        }
    }

    protected static Field createField(ComplexType type, XSElementDecl element, Type fieldType) {
        String elementName = element.getName();
        XmlString dv = element.getDefaultValue();
        String defValue = null;
        if (dv != null) {
            defValue = dv.value;
        }
        int flags = 0;
        if (defValue == null && (dv = element.getFixedValue()) != null) {
            defValue = dv.value;
            flags |= 2;
        }
        if (element.isNillable()) {
            flags |= 1;
        }
        Field field = type.addField(elementName, fieldType, defValue, flags);
        if (fieldType instanceof SimpleTypeImpl) {
            for (Constraint constraint : ((SimpleTypeImpl)fieldType).getConstraints()) {
                if (!(constraint instanceof StringLengthConstraint)) continue;
                StringLengthConstraint slc = (StringLengthConstraint)constraint;
                field.setMaxLength(slc.getMax());
            }
        }
        return field;
    }

    protected static Field createField(ComplexType type, XSAttributeDecl element, Type fieldType) {
        String elementName = element.getName();
        XmlString dv = element.getDefaultValue();
        String defValue = null;
        if (dv != null) {
            defValue = dv.value;
        }
        int flags = 0;
        if (defValue == null && (dv = element.getFixedValue()) != null) {
            defValue = dv.value;
            flags |= 2;
        }
        return type.addField(elementName, fieldType, defValue, flags);
    }

    protected static String getAnonymousTypeName(XSType type, String fieldName) {
        if (type.isComplexType()) {
            XSElementDecl container = type.asComplexType().getScope();
            String elName = container.getName();
            return elName + ANONYMOUS_TYPE_SUFFIX;
        }
        return fieldName + ANONYMOUS_TYPE_SUFFIX;
    }

    public List<String> getReferencedXSD() {
        return this.referencedXSD;
    }

    protected static class SchemaErrorHandler
    implements ErrorHandler {
        protected SchemaErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            log.error((Object)("Error: " + e.getMessage()));
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            log.error((Object)("FatalError: " + e.getMessage()));
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            log.error((Object)("Warning: " + e.getMessage()));
        }
    }

    protected static class NXSchemaResolver
    implements EntityResolver {
        protected SchemaManagerImpl schemaManager;
        protected SchemaBindingDescriptor sd;

        NXSchemaResolver(SchemaManagerImpl schemaManager, SchemaBindingDescriptor sd) {
            this.schemaManager = schemaManager;
            this.sd = sd;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String[] parts = systemId.split("/schemas/");
            String importXSDSubPath = parts[1];
            File xsd = new File(this.schemaManager.getSchemasDir(), importXSDSubPath);
            if (!xsd.exists()) {
                int idx = this.sd.src.lastIndexOf("/");
                importXSDSubPath = this.sd.src.substring(0, idx + 1) + importXSDSubPath;
                URL url = this.sd.context.getLocalResource(importXSDSubPath);
                if (url == null) {
                    url = this.sd.context.getResource(importXSDSubPath);
                }
                if (url != null) {
                    return new InputSource(url.openStream());
                }
            }
            return null;
        }
    }
}

