/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.DocumentTypeImpl;
import org.nuxeo.ecm.core.schema.FacetDescriptor;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.ProxiesDescriptor;
import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.nuxeo.ecm.core.schema.SchemaDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConfiguration;
import org.nuxeo.ecm.core.schema.XSDLoader;
import org.nuxeo.ecm.core.schema.XSDTypes;
import org.nuxeo.ecm.core.schema.types.AnyType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.CompositeTypeImpl;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.runtime.api.Framework;
import org.xml.sax.SAXException;

public class SchemaManagerImpl
implements SchemaManager {
    private static final Log log = LogFactory.getLog(SchemaManagerImpl.class);
    protected volatile boolean dirty = true;
    protected Map<String, Type> types = new HashMap<String, Type>();
    protected List<TypeConfiguration> allConfigurations = new ArrayList<TypeConfiguration>();
    protected List<SchemaBindingDescriptor> allSchemas = new ArrayList<SchemaBindingDescriptor>();
    protected List<FacetDescriptor> allFacets = new ArrayList<FacetDescriptor>();
    protected List<DocumentTypeDescriptor> allDocumentTypes = new ArrayList<DocumentTypeDescriptor>();
    protected List<ProxiesDescriptor> allProxies = new ArrayList<ProxiesDescriptor>();
    protected PrefetchInfo prefetchInfo;
    protected Map<String, Schema> schemas = new HashMap<String, Schema>();
    protected final Map<String, Schema> uriToSchema = new HashMap<String, Schema>();
    protected final Map<String, Schema> prefixToSchema = new HashMap<String, Schema>();
    protected Map<String, CompositeType> facets = new HashMap<String, CompositeType>();
    protected Set<String> noPerDocumentQueryFacets = new HashSet<String>();
    protected Map<String, DocumentTypeImpl> documentTypes = new HashMap<String, DocumentTypeImpl>();
    protected Map<String, Set<String>> documentTypesExtending = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> documentTypesForFacet = new HashMap<String, Set<String>>();
    protected List<Schema> proxySchemas = new ArrayList<Schema>();
    protected Set<String> proxySchemaNames = new HashSet<String>();
    private Map<String, Field> fields = new ConcurrentHashMap<String, Field>();
    private File schemaDir = new File(Framework.getRuntime().getHome(), "schemas");
    public static final String SCHEMAS_DIR_NAME = "schemas";

    public SchemaManagerImpl() {
        if (!this.schemaDir.isDirectory()) {
            this.schemaDir.mkdirs();
        }
        this.registerBuiltinTypes();
    }

    public File getSchemasDir() {
        return this.schemaDir;
    }

    protected void registerBuiltinTypes() {
        for (Type type : XSDTypes.getTypes()) {
            this.registerType(type);
        }
        this.registerType(AnyType.INSTANCE);
    }

    protected void registerType(Type type) {
        this.types.put(type.getName(), type);
    }

    protected Type getType(String name) {
        return this.types.get(name);
    }

    protected Collection<Type> getTypes() {
        return this.types.values();
    }

    public synchronized void registerConfiguration(TypeConfiguration config) {
        this.allConfigurations.add(config);
        this.dirty = true;
        log.info((Object)("Registered global prefetch: " + config.prefetchInfo));
    }

    public synchronized void unregisterConfiguration(TypeConfiguration config) {
        if (this.allConfigurations.remove(config)) {
            this.dirty = true;
            log.info((Object)("Unregistered global prefetch: " + config.prefetchInfo));
        } else {
            log.error((Object)("Unregistering unknown prefetch: " + config.prefetchInfo));
        }
    }

    public synchronized void registerSchema(SchemaBindingDescriptor sd) {
        this.allSchemas.add(sd);
        this.dirty = true;
        log.info((Object)("Registered schema: " + sd.name));
    }

    public synchronized void unregisterSchema(SchemaBindingDescriptor sd) {
        if (this.allSchemas.remove(sd)) {
            this.dirty = true;
            log.info((Object)("Unregistered schema: " + sd.name));
        } else {
            log.error((Object)("Unregistering unknown schema: " + sd.name));
        }
    }

    public synchronized void registerFacet(FacetDescriptor fd) {
        this.allFacets.add(fd);
        this.dirty = true;
        log.info((Object)("Registered facet: " + fd.name));
    }

    public synchronized void unregisterFacet(FacetDescriptor fd) {
        if (this.allFacets.remove(fd)) {
            this.dirty = true;
            log.info((Object)("Unregistered facet: " + fd.name));
        } else {
            log.error((Object)("Unregistering unknown facet: " + fd.name));
        }
    }

    public synchronized void registerDocumentType(DocumentTypeDescriptor dtd) {
        this.allDocumentTypes.add(dtd);
        this.dirty = true;
        log.info((Object)("Registered document type: " + dtd.name));
    }

    public synchronized void unregisterDocumentType(DocumentTypeDescriptor dtd) {
        if (this.allDocumentTypes.remove(dtd)) {
            this.dirty = true;
            log.info((Object)("Unregistered document type: " + dtd.name));
        } else {
            log.error((Object)("Unregistering unknown document type: " + dtd.name));
        }
    }

    public DocumentTypeDescriptor getDocumentTypeDescriptor(String name) {
        DocumentTypeDescriptor last = null;
        for (DocumentTypeDescriptor dtd : this.allDocumentTypes) {
            if (!dtd.name.equals(name)) continue;
            last = dtd;
        }
        return last;
    }

    public synchronized void registerProxies(ProxiesDescriptor pd) {
        this.allProxies.add(pd);
        this.dirty = true;
        log.info((Object)("Registered proxies descriptor for schemas: " + pd.getSchemas()));
    }

    public synchronized void unregisterProxies(ProxiesDescriptor pd) {
        if (this.allProxies.remove(pd)) {
            this.dirty = true;
            log.info((Object)("Unregistered proxies descriptor for schemas: " + pd.getSchemas()));
        } else {
            log.error((Object)("Unregistering unknown proxies descriptor for schemas: " + pd.getSchemas()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDirty() {
        if (!this.dirty) {
            return;
        }
        SchemaManagerImpl schemaManagerImpl = this;
        synchronized (schemaManagerImpl) {
            if (!this.dirty) {
                return;
            }
            this.recompute();
            this.dirty = false;
        }
    }

    protected void recompute() {
        this.recomputeConfiguration();
        this.recomputeSchemas();
        this.recomputeFacets();
        this.recomputeDocumentTypes();
        this.recomputeProxies();
        this.fields.clear();
    }

    protected void recomputeConfiguration() {
        if (this.allConfigurations.isEmpty()) {
            this.prefetchInfo = null;
        } else {
            TypeConfiguration last = this.allConfigurations.get(this.allConfigurations.size() - 1);
            this.prefetchInfo = new PrefetchInfo(last.prefetchInfo);
        }
    }

    protected void recomputeSchemas() {
        this.schemas.clear();
        this.uriToSchema.clear();
        this.prefixToSchema.clear();
        RuntimeException errors = new RuntimeException("Cannot load schemas");
        for (SchemaBindingDescriptor sd : this.allSchemas) {
            try {
                this.copySchema(sd);
            }
            catch (Exception error) {
                if (error instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                errors.addSuppressed(error);
            }
        }
        for (SchemaBindingDescriptor sd : this.allSchemas) {
            try {
                this.loadSchema(sd);
            }
            catch (Exception error) {
                if (error instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                errors.addSuppressed(error);
            }
        }
        if (errors.getSuppressed().length > 0) {
            throw errors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copySchema(SchemaBindingDescriptor sd) throws IOException, SAXException, TypeException {
        if (sd.src == null || sd.src.length() == 0) {
            return;
        }
        URL url = sd.context.getLocalResource(sd.src);
        if (url == null) {
            url = sd.context.getResource(sd.src);
        }
        if (url == null) {
            log.error((Object)("XSD Schema not found: " + sd.src));
            return;
        }
        try (InputStream in = url.openStream();){
            sd.file = new File(this.schemaDir, sd.name + ".xsd");
            FileUtils.copyToFile((InputStream)in, (File)sd.file);
        }
    }

    protected void loadSchema(SchemaBindingDescriptor sd) throws IOException, SAXException, TypeException {
        if (sd.file == null) {
            return;
        }
        XSDLoader schemaLoader = new XSDLoader(this, sd);
        Schema oldschema = this.schemas.get(sd.name);
        schemaLoader.loadSchema(sd.name, sd.prefix, sd.file, sd.override, sd.xsdRootElement);
        if (oldschema == null) {
            log.info((Object)("Registered schema: " + sd.name + " from " + sd.file));
        } else {
            log.info((Object)("Reregistered schema: " + sd.name));
        }
    }

    protected Schema getSchemaInternal(String name) {
        return this.schemas.get(name);
    }

    protected void registerSchema(Schema schema) {
        this.schemas.put(schema.getName(), schema);
        Namespace ns = schema.getNamespace();
        this.uriToSchema.put(ns.uri, schema);
        if (!StringUtils.isBlank((String)ns.prefix)) {
            this.prefixToSchema.put(ns.prefix, schema);
        }
    }

    @Override
    public Schema[] getSchemas() {
        this.checkDirty();
        return new ArrayList<Schema>(this.schemas.values()).toArray(new Schema[0]);
    }

    @Override
    public Schema getSchema(String name) {
        this.checkDirty();
        return this.schemas.get(name);
    }

    @Override
    public Schema getSchemaFromPrefix(String schemaPrefix) {
        this.checkDirty();
        return this.prefixToSchema.get(schemaPrefix);
    }

    @Override
    public Schema getSchemaFromURI(String schemaURI) {
        this.checkDirty();
        return this.uriToSchema.get(schemaURI);
    }

    protected void recomputeFacets() {
        this.facets.clear();
        this.noPerDocumentQueryFacets.clear();
        for (FacetDescriptor fd : this.allFacets) {
            this.recomputeFacet(fd);
        }
    }

    protected void recomputeFacet(FacetDescriptor fd) {
        Set<String> schemas = SchemaDescriptor.getSchemaNames(fd.schemas);
        this.registerFacet(fd.name, schemas);
        if (Boolean.FALSE.equals(fd.perDocumentQuery)) {
            this.noPerDocumentQueryFacets.add(fd.name);
        }
    }

    protected CompositeType registerFacet(String name, Set<String> schemaNames) {
        ArrayList<Schema> facetSchemas = new ArrayList<Schema>(schemaNames.size());
        for (String schemaName : schemaNames) {
            Schema schema = this.schemas.get(schemaName);
            if (schema == null) {
                log.error((Object)("Facet: " + name + " uses unknown schema: " + schemaName));
                continue;
            }
            facetSchemas.add(schema);
        }
        CompositeTypeImpl ct = new CompositeTypeImpl(null, "@facets", name, facetSchemas);
        this.facets.put(name, ct);
        return ct;
    }

    @Override
    public CompositeType[] getFacets() {
        this.checkDirty();
        return new ArrayList<CompositeType>(this.facets.values()).toArray(new CompositeType[this.facets.size()]);
    }

    @Override
    public CompositeType getFacet(String name) {
        this.checkDirty();
        return this.facets.get(name);
    }

    @Override
    public Set<String> getNoPerDocumentQueryFacets() {
        this.checkDirty();
        return Collections.unmodifiableSet(this.noPerDocumentQueryFacets);
    }

    protected void recomputeDocumentTypes() {
        LinkedHashMap<String, DocumentTypeDescriptor> dtds = new LinkedHashMap<String, DocumentTypeDescriptor>();
        for (DocumentTypeDescriptor documentTypeDescriptor : this.allDocumentTypes) {
            String name = documentTypeDescriptor.name;
            DocumentTypeDescriptor newDtd = documentTypeDescriptor;
            if (documentTypeDescriptor.append && dtds.containsKey(documentTypeDescriptor.name)) {
                newDtd = this.mergeDocumentTypeDescriptors(documentTypeDescriptor, (DocumentTypeDescriptor)dtds.get(name));
            }
            dtds.put(name, newDtd);
        }
        this.documentTypes.clear();
        this.documentTypesExtending.clear();
        this.registerDocumentType(new DocumentTypeImpl("Document"));
        for (String string : dtds.keySet()) {
            LinkedHashSet<String> stack = new LinkedHashSet<String>();
            this.recomputeDocumentType(string, stack, dtds);
        }
        this.documentTypesForFacet.clear();
        for (DocumentType documentType : this.documentTypes.values()) {
            for (String facet : documentType.getFacets()) {
                Set<String> set = this.documentTypesForFacet.get(facet);
                if (set == null) {
                    set = new HashSet<String>();
                    this.documentTypesForFacet.put(facet, set);
                }
                set.add(documentType.getName());
            }
        }
    }

    protected DocumentTypeDescriptor mergeDocumentTypeDescriptors(DocumentTypeDescriptor src, DocumentTypeDescriptor dst) {
        return dst.clone().merge(src);
    }

    protected DocumentType recomputeDocumentType(String name, Set<String> stack, Map<String, DocumentTypeDescriptor> dtds) {
        DocumentType parent;
        DocumentTypeImpl docType = this.documentTypes.get(name);
        if (docType != null) {
            return docType;
        }
        if (stack.contains(name)) {
            log.error((Object)("Document type: " + name + " used in parent inheritance loop: " + stack));
            return null;
        }
        DocumentTypeDescriptor dtd = dtds.get(name);
        if (dtd == null) {
            log.error((Object)("Document type: " + name + " does not exist, used as parent by type: " + stack));
            return null;
        }
        String parentName = dtd.superTypeName;
        if (parentName == null) {
            parent = null;
        } else {
            parent = this.documentTypes.get(parentName);
            if (parent == null) {
                stack.add(name);
                parent = this.recomputeDocumentType(parentName, stack, dtds);
                stack.remove(name);
            }
        }
        for (Type p = parent; p != null; p = p.getSuperType()) {
            Set<String> set = this.documentTypesExtending.get(p.getName());
            set.add(name);
        }
        return this.recomputeDocumentType(name, dtd, parent);
    }

    protected DocumentType recomputeDocumentType(String name, DocumentTypeDescriptor dtd, DocumentType parent) {
        HashSet<String> facetNames = new HashSet<String>();
        Set<String> schemaNames = SchemaDescriptor.getSchemaNames(dtd.schemas);
        facetNames.addAll(Arrays.asList(dtd.facets));
        if (parent != null) {
            facetNames.addAll(parent.getFacets());
            schemaNames.addAll(Arrays.asList(parent.getSchemaNames()));
        }
        for (String facetName : facetNames) {
            CompositeType ct = this.facets.get(facetName);
            if (ct == null) {
                log.warn((Object)("Undeclared facet: " + facetName + " used in document type: " + name));
                ct = this.registerFacet(facetName, Collections.emptySet());
            }
            schemaNames.addAll(Arrays.asList(ct.getSchemaNames()));
        }
        ArrayList<Schema> docTypeSchemas = new ArrayList<Schema>();
        for (String schemaName : schemaNames) {
            Schema schema = this.schemas.get(schemaName);
            if (schema == null) {
                log.error((Object)("Document type: " + name + " uses unknown schema: " + schemaName));
                continue;
            }
            docTypeSchemas.add(schema);
        }
        PrefetchInfo prefetch = dtd.prefetch == null ? this.prefetchInfo : new PrefetchInfo(dtd.prefetch);
        DocumentTypeImpl docType = new DocumentTypeImpl(name, parent, docTypeSchemas, facetNames, prefetch);
        this.registerDocumentType(docType);
        return docType;
    }

    protected void registerDocumentType(DocumentTypeImpl docType) {
        String name = docType.getName();
        this.documentTypes.put(name, docType);
        this.documentTypesExtending.put(name, new HashSet<String>(Collections.singleton(name)));
    }

    @Override
    public DocumentType getDocumentType(String name) {
        this.checkDirty();
        return this.documentTypes.get(name);
    }

    @Override
    public Set<String> getDocumentTypeNamesForFacet(String facet) {
        this.checkDirty();
        return this.documentTypesForFacet.get(facet);
    }

    @Override
    public Set<String> getDocumentTypeNamesExtending(String docTypeName) {
        this.checkDirty();
        return this.documentTypesExtending.get(docTypeName);
    }

    @Override
    public DocumentType[] getDocumentTypes() {
        this.checkDirty();
        return new ArrayList<DocumentTypeImpl>(this.documentTypes.values()).toArray(new DocumentType[0]);
    }

    @Override
    public int getDocumentTypesCount() {
        this.checkDirty();
        return this.documentTypes.size();
    }

    @Override
    public boolean hasSuperType(String docType, String superType) {
        if (docType == null || superType == null) {
            return false;
        }
        Set<String> types = this.getDocumentTypeNamesExtending(superType);
        return types != null && types.contains(docType);
    }

    protected void recomputeProxies() {
        ArrayList<Schema> list = new ArrayList<Schema>();
        HashSet<String> nameSet = new HashSet<String>();
        for (ProxiesDescriptor pd : this.allProxies) {
            if (!pd.getType().equals("*")) {
                log.error((Object)("Proxy descriptor for specific type not supported: " + pd));
            }
            for (String schemaName : pd.getSchemas()) {
                if (nameSet.contains(schemaName)) continue;
                Schema schema = this.schemas.get(schemaName);
                if (schema == null) {
                    log.error((Object)("Proxy schema uses unknown schema: " + schemaName));
                    continue;
                }
                list.add(schema);
                nameSet.add(schemaName);
            }
        }
        this.proxySchemas = list;
        this.proxySchemaNames = nameSet;
    }

    @Override
    public List<Schema> getProxySchemas(String docType) {
        this.checkDirty();
        return new ArrayList<Schema>(this.proxySchemas);
    }

    @Override
    public boolean isProxySchema(String schema, String docType) {
        this.checkDirty();
        return this.proxySchemaNames.contains(schema);
    }

    @Override
    public Field getField(String prefixedName) {
        this.checkDirty();
        Field field = this.fields.get(prefixedName);
        if (field == null) {
            QName qname = QName.valueOf(prefixedName);
            String prefix = qname.getPrefix();
            Schema schema = this.getSchemaFromPrefix(prefix);
            if (schema == null) {
                schema = this.getSchema(prefix);
            }
            if (schema != null && (field = schema.getField(qname.getLocalName())) != null) {
                this.fields.put(prefixedName, field);
            }
        }
        return field;
    }

    public void flushPendingsRegistration() {
        this.checkDirty();
    }
}

