/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.types.CompositeTypeImpl;
import org.nuxeo.ecm.core.schema.types.Schema;

public class DocumentTypeImpl
extends CompositeTypeImpl
implements DocumentType {
    private static final long serialVersionUID = 1L;
    protected Set<String> facets;
    protected PrefetchInfo prefetchInfo;

    public DocumentTypeImpl(String name, DocumentType superType, List<Schema> schemas, Collection<String> facets, PrefetchInfo prefetchInfo) {
        super(superType, "@doctypes", name, schemas);
        this.facets = facets == null ? Collections.emptySet() : new HashSet<String>(facets);
        this.prefetchInfo = prefetchInfo;
    }

    public DocumentTypeImpl(String name) {
        this(name, null, Collections.emptyList(), Collections.emptySet(), null);
    }

    public void setPrefetchInfo(PrefetchInfo prefetchInfo) {
        this.prefetchInfo = prefetchInfo;
    }

    @Override
    public PrefetchInfo getPrefetchInfo() {
        return this.prefetchInfo;
    }

    @Override
    public boolean isFile() {
        return !this.facets.contains("Folderish");
    }

    @Override
    public boolean isFolder() {
        return this.facets.contains("Folderish");
    }

    @Override
    public boolean isOrdered() {
        return this.facets.contains("Orderable");
    }

    @Override
    public Set<String> getFacets() {
        return this.facets;
    }

    @Override
    public boolean hasFacet(String facetName) {
        return this.facets.contains(facetName);
    }
}

