/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

public final class DocumentsListsUtils {
    private static final Log log = LogFactory.getLog(DocumentsListsUtils.class);

    private DocumentsListsUtils() {
    }

    public static List<String> getTypesInList(List<DocumentModel> documentsList) {
        ArrayList<String> res = new ArrayList<String>();
        for (DocumentModel doc : documentsList) {
            String dt = doc.getType();
            if (res.contains(dt)) continue;
            res.add(dt);
        }
        return res;
    }

    public static List<DocumentRef> getDocRefs(List<DocumentModel> documentsList) {
        ArrayList<DocumentRef> references = new ArrayList<DocumentRef>();
        for (DocumentModel docModel : documentsList) {
            references.add(docModel.getRef());
        }
        return references;
    }

    public static boolean removeDocumentFromList(List<DocumentModel> documentList, DocumentModel documentToRemove) {
        if (null == documentToRemove) {
            return false;
        }
        try {
            boolean found = false;
            for (int i = 0; i < documentList.size(); ++i) {
                if (!documentList.get(i).getRef().equals(documentToRemove.getRef())) continue;
                documentList.remove(i);
                found = true;
            }
            return found;
        }
        catch (UnsupportedOperationException e) {
            log.error((Object)("immutable list, cannot remove document: " + documentToRemove), (Throwable)e);
            return false;
        }
    }

    public static void removeDocumentsFromList(List<DocumentModel> documentList, List<DocumentModel> documentsToRemove) {
        if (null == documentsToRemove || documentsToRemove.isEmpty()) {
            return;
        }
        if (null == documentList || documentList.isEmpty()) {
            return;
        }
        for (DocumentModel documentToRemove : documentsToRemove) {
            for (int i = 0; i < documentList.size(); ++i) {
                if (!documentList.get(i).getRef().equals(documentToRemove.getRef())) continue;
                documentList.remove(i);
            }
        }
    }

    public static List<DocumentRef> getParentRefFromDocumentList(List<DocumentModel> documentList) {
        ArrayList<DocumentRef> parentRefs = new ArrayList<DocumentRef>();
        for (DocumentModel doc : documentList) {
            if (parentRefs.contains(doc.getParentRef())) continue;
            parentRefs.add(doc.getParentRef());
        }
        return parentRefs;
    }

    public static boolean isDocumentInList(DocumentModel doc, List<DocumentModel> list) {
        String strDocRef = doc.getRef().toString();
        for (DocumentModel d : list) {
            if (!strDocRef.equals(d.getRef().toString())) continue;
            return true;
        }
        return false;
    }
}

