/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.el.PropertyNotFoundException;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.platform.ui.web.component.SelectItemsFactory;
import org.nuxeo.ecm.platform.ui.web.component.VariableManager;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItem;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItemFactory;

public abstract class DirectorySelectItemsFactory
extends SelectItemsFactory {
    private static final Log log = LogFactory.getLog(DirectorySelectItemsFactory.class);

    @Override
    protected abstract String getVar();

    protected abstract String getDirectoryName();

    protected abstract String getFilter();

    protected abstract boolean isDisplayObsoleteEntries();

    protected abstract DirectorySelectItem createSelectItem(String var1, Long var2);

    protected abstract String retrieveSelectEntryId();

    protected abstract Object retrieveItemLabel();

    protected abstract String retrieveLabelFromEntry(DocumentModel var1);

    protected abstract Long retrieveOrderingFromEntry(DocumentModel var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DirectorySelectItem> createDirectorySelectItems(Object value) {
        Object varValue = this.saveRequestMapVarValue();
        try {
            ArrayList<DirectorySelectItem> items = new ArrayList<DirectorySelectItem>();
            String dirName = this.getDirectoryName();
            if (StringUtils.isBlank((String)dirName)) {
                items.add(new DirectorySelectItem("", "ERROR: mising directoryName property configuration on widget"));
            } else {
                Session directorySession = DirectorySelectItemFactory.getDirectorySession(dirName);
                if (directorySession != null) {
                    if (value instanceof ListDataModel) {
                        ListDataModel ldm = (ListDataModel)value;
                        List entries = (List)ldm.getWrappedData();
                        for (Object entry : entries) {
                            DirectorySelectItem res = this.createSelectItemFrom(directorySession, entry);
                            if (res == null) continue;
                            items.add(res);
                        }
                    } else if (value instanceof Collection) {
                        Collection collection = (Collection)value;
                        for (Object entry : collection) {
                            DirectorySelectItem res = this.createSelectItemFrom(directorySession, entry);
                            if (res == null) continue;
                            items.add(res);
                        }
                    } else if (value instanceof Object[]) {
                        Object[] entries;
                        for (Object entry : entries = (Object[])value) {
                            DirectorySelectItem res = this.createSelectItemFrom(directorySession, entry);
                            if (res == null) continue;
                            items.add(res);
                        }
                    }
                } else {
                    items.add(new DirectorySelectItem("", String.format("ERROR: mising directorySession for directory '%s'", dirName)));
                }
                DirectorySelectItemFactory.closeDirectorySession(directorySession);
            }
            ArrayList<DirectorySelectItem> arrayList = items;
            return arrayList;
        }
        finally {
            this.restoreRequestMapVarValue(varValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DirectorySelectItem> createAllDirectorySelectItems() {
        Object varValue = this.saveRequestMapVarValue();
        try {
            ArrayList<DirectorySelectItem> items = new ArrayList<DirectorySelectItem>();
            Session directorySession = DirectorySelectItemFactory.getDirectorySession(this.getDirectoryName());
            if (directorySession != null) {
                try {
                    HashMap<String, Object> filter = new HashMap<String, Object>();
                    if (!this.isDisplayObsoleteEntries()) {
                        filter.put("obsolete", 0);
                    }
                    if (this.getFilter() != null) {
                        filter.put("parentFilter", this.getFilter());
                    }
                    DocumentModelList entries = directorySession.query(filter);
                    for (DocumentModel entry : entries) {
                        DirectorySelectItem res;
                        if (entry == null || (res = this.createSelectItemForEntry(entry, entry)) == null) continue;
                        items.add(res);
                    }
                }
                catch (ClientException e) {
                    log.error((Object)e, (Throwable)e);
                }
            } else {
                log.error((Object)"No session provided for directory, returning empty selection");
            }
            DirectorySelectItemFactory.closeDirectorySession(directorySession);
            ArrayList<DirectorySelectItem> arrayList = items;
            return arrayList;
        }
        finally {
            this.restoreRequestMapVarValue(varValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String retrieveEntryIdFrom(Object item) {
        Object varValue = this.saveRequestMapVarValue();
        try {
            this.putIteratorToRequestParam(item);
            String id = this.retrieveSelectEntryId();
            this.removeIteratorFromRequestParam();
            String string = id;
            return string;
        }
        finally {
            this.restoreRequestMapVarValue(varValue);
        }
    }

    protected DirectorySelectItem createSelectItemForEntry(Object itemValue, DocumentModel entry) {
        String var = this.getVar();
        String varEntry = var + "Entry";
        Object varEntryExisting = VariableManager.saveRequestMapVarValue(varEntry);
        DirectorySelectItem selectItem = null;
        try {
            VariableManager.putVariableToRequestParam(var, itemValue);
            VariableManager.putVariableToRequestParam(varEntry, entry);
            String label = this.retrieveLabelFromEntry(entry);
            Long ordering = this.retrieveOrderingFromEntry(entry);
            selectItem = this.createSelectItem(label, ordering);
            this.removeIteratorFromRequestParam();
            VariableManager.removeVariableFromRequestParam(var);
            VariableManager.removeVariableFromRequestParam(varEntry);
            if (selectItem != null) {
                DirectorySelectItem directorySelectItem = selectItem;
                return directorySelectItem;
            }
            if (itemValue instanceof DirectorySelectItem) {
                DirectorySelectItem directorySelectItem = (DirectorySelectItem)((Object)itemValue);
                return directorySelectItem;
            }
            DirectorySelectItem directorySelectItem = selectItem;
            return directorySelectItem;
        }
        catch (PropertyNotFoundException e) {
            if (itemValue instanceof DirectorySelectItem) {
                DirectorySelectItem directorySelectItem = (DirectorySelectItem)((Object)itemValue);
                return directorySelectItem;
            }
            throw e;
        }
        finally {
            VariableManager.restoreRequestMapVarValue(varEntry, varEntryExisting);
        }
    }

    protected DirectorySelectItem createSelectItemFrom(Session session, Object entry) {
        String entryId = entry instanceof String ? (String)entry : this.retrieveEntryIdFrom(entry);
        if (StringUtils.isBlank((String)entryId)) {
            return null;
        }
        try {
            DocumentModel docEntry = session.getEntry(entryId);
            if (docEntry == null) {
                String label;
                this.putIteratorToRequestParam(entry);
                Object labelObject = this.retrieveItemLabel();
                String string = label = labelObject == null ? null : String.valueOf(labelObject);
                if (StringUtils.isBlank((String)label)) {
                    label = entryId;
                }
                DirectorySelectItem item = this.createSelectItem(label, 0L);
                this.removeIteratorFromRequestParam();
                return item;
            }
            return this.createSelectItemForEntry(entry, docEntry);
        }
        catch (DirectoryException e) {
            return null;
        }
    }

    @Override
    public SelectItem createSelectItem() {
        throw new IllegalArgumentException("Use createSelectDirectoryItems instead");
    }
}

