/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding.alias;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasValueExpression;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapperWrapper;
import org.nuxeo.ecm.platform.ui.web.binding.alias.NuxeoAliasBean;

public class AliasVariableMapper
extends VariableMapper {
    private static final Log log = LogFactory.getLog(AliasVariableMapper.class);
    public static final String REQUEST_MARKER = AliasVariableMapper.class.getName() + "_MARKER";
    protected String id;
    protected Map<String, ValueExpression> vars;
    protected List<String> blockedPatterns;

    public AliasVariableMapper() {
    }

    public AliasVariableMapper(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ValueExpression resolveVariable(String variable) {
        ValueExpression ve = null;
        if (this.vars != null) {
            ve = this.vars.get(variable);
        }
        return ve;
    }

    public ValueExpression setVariable(String variable, ValueExpression expression) {
        if (this.vars == null) {
            this.vars = new LinkedHashMap<String, ValueExpression>();
        }
        return this.vars.put(variable, expression);
    }

    public boolean hasVariables(String variable) {
        return this.vars != null && this.vars.containsKey(variable);
    }

    public VariableMapper getVariableMapperForBuild(VariableMapper orig) {
        AliasVariableMapperWrapper vm = new AliasVariableMapperWrapper(orig, this.getBlockedPatterns());
        Map<String, ValueExpression> vars = this.getVariables();
        if (vars != null) {
            String id = this.getId();
            for (Map.Entry<String, ValueExpression> var : vars.entrySet()) {
                vm.setVariable(var.getKey(), new AliasValueExpression(id, var.getKey()));
            }
        }
        return vm;
    }

    public Map<String, ValueExpression> getVariables() {
        return this.vars;
    }

    public List<String> getBlockedPatterns() {
        return this.blockedPatterns;
    }

    public void setBlockedPatterns(List<String> blockedPatterns) {
        this.blockedPatterns = blockedPatterns;
    }

    public static AliasVariableMapper getVariableMapper(FacesContext ctx, String id) {
        NuxeoAliasBean a = AliasVariableMapper.lookupBean(ctx);
        if (a != null) {
            return a.get(id);
        }
        return null;
    }

    public static void exposeAliasesToRequest(FacesContext ctx, AliasVariableMapper vm) {
        NuxeoAliasBean a = AliasVariableMapper.lookupBean(ctx);
        if (a != null) {
            a.add(vm);
        }
    }

    public static void removeAliasesExposedToRequest(FacesContext ctx, String id) {
    }

    protected static NuxeoAliasBean lookupBean(FacesContext ctx) {
        String expr = "#{nuxeoAliasBean}";
        NuxeoAliasBean bean = (NuxeoAliasBean)ctx.getApplication().evaluateExpressionGet(ctx, expr, Object.class);
        if (bean == null) {
            log.error((Object)("Managed bean not found: " + expr));
            return null;
        }
        return bean;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(((Object)((Object)this)).getClass().getSimpleName());
        buf.append(" {");
        buf.append(" id=");
        buf.append(this.id);
        buf.append(", vars=");
        buf.append(this.vars);
        buf.append('}');
        return buf.toString();
    }
}

