/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.application;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.ClientSideStateHelper;
import com.sun.faces.renderkit.ResponseStateManagerImpl;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.RequestStateManager;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.platform.ui.web.application.NuxeoServerSideStateHelper;

public class NuxeoResponseStateManagerImpl
extends ResponseStateManagerImpl {
    public static final String MULTIPART_SIZE_ERROR_FLAG = "NX_MULTIPART_SIZE_ERROR";
    public static final Object MULTIPART_SIZE_ERROR_COMPONENT_ID = "NX_MULTIPART_SIZE_COMPONENTID";
    private final StateHelper helper;

    public NuxeoResponseStateManagerImpl() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        String stateMode = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.StateSavingMethod);
        this.helper = "client".equalsIgnoreCase(stateMode) ? new ClientSideStateHelper() : new NuxeoServerSideStateHelper();
    }

    public String getCryptographicallyStrongTokenFromSession(FacesContext context) {
        return this.helper.getCryptographicallyStrongTokenFromSession(context);
    }

    public Object getState(FacesContext context, String viewId) {
        Object state = RequestStateManager.get((FacesContext)context, (String)"com.sun.faces.FACES_VIEW_STATE");
        if (state == null) {
            try {
                state = this.helper.getState(context, viewId);
                if (state != null) {
                    RequestStateManager.set((FacesContext)context, (String)"com.sun.faces.FACES_VIEW_STATE", (Object)state);
                }
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return state;
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        this.helper.writeState(context, state, null);
    }

    public String getViewState(FacesContext context, Object state) {
        StringBuilder sb = new StringBuilder(32);
        try {
            this.helper.writeState(context, state, sb);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        return sb.toString();
    }

    public boolean isStateless(FacesContext facesContext, String viewId) {
        return this.helper.isStateless(facesContext, viewId);
    }

    public boolean isPostback(FacesContext context) {
        HttpServletRequest req;
        String contentType;
        boolean result = super.isPostback(context);
        if (!result && (contentType = (req = (HttpServletRequest)context.getExternalContext().getRequest()).getContentType()) != null && contentType.contains("multipart/form-data")) {
            try {
                req.getParts();
            }
            catch (IllegalStateException e) {
                String componentId;
                context.getAttributes().put(MULTIPART_SIZE_ERROR_FLAG, true);
                if (e.getCause() != null && (componentId = NuxeoResponseStateManagerImpl.getComponentId(e.getCause().getMessage())) != null) {
                    context.getAttributes().put(MULTIPART_SIZE_ERROR_COMPONENT_ID, componentId);
                }
            }
            catch (IOException e) {
            }
            catch (ServletException e) {
                // empty catch block
            }
        }
        return result;
    }

    private static String getComponentId(String excetionMessage) {
        String sep = ":";
        if (excetionMessage.indexOf(sep) > 0) {
            String[] split = excetionMessage.split(sep);
            String result = "";
            if (split != null && split.length > 0) {
                result = result + split[0].substring(split[0].lastIndexOf(" ") + 1);
                for (int i = 1; i < split.length - 1; ++i) {
                    result = result + sep + split[i];
                }
                result = result + sep + split[split.length - 1].substring(0, split[split.length - 1].indexOf(32));
            }
            return result;
        }
        return null;
    }
}

