/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.query;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.query.QueryFacet;

public class InternalQueryFacet
extends InternalFacet
implements QueryFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray(Strings.toUTF8Bytes("query"));
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalQueryFacet.readQueryFacet(in);
        }
    };
    private long count;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    private InternalQueryFacet() {
    }

    public InternalQueryFacet(String name, long count) {
        super(name);
        this.count = count;
    }

    @Override
    public String getType() {
        return "query";
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public Facet reduce(InternalFacet.ReduceContext context) {
        List<Facet> facets = context.facets();
        if (facets.size() == 1) {
            return facets.get(0);
        }
        long count = 0L;
        for (Facet facet : facets) {
            count += ((QueryFacet)facet).getCount();
        }
        return new InternalQueryFacet(this.getName(), count);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "query");
        builder.field(Fields.COUNT, this.count);
        builder.endObject();
        return builder;
    }

    public static QueryFacet readQueryFacet(StreamInput in) throws IOException {
        InternalQueryFacet result = new InternalQueryFacet();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.count = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.count);
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }
}

