/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.cardinality;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.core.Murmur3FieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.cardinality.InternalCardinality;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.bytes.BytesValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class CardinalityParser
implements Aggregator.Parser {
    private static final ParseField PRECISION_THRESHOLD = new ParseField("precision_threshold", new String[0]);

    @Override
    public String type() {
        return InternalCardinality.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String name, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        long precisionThreshold = -1L;
        Boolean rehash = null;
        String field = null;
        String script = null;
        String scriptLang = null;
        Map<String, Object> scriptParams = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("field".equals(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if ("script".equals(currentFieldName)) {
                    script = parser.text();
                    continue;
                }
                if ("lang".equals(currentFieldName)) {
                    scriptLang = parser.text();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + name + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentFieldName)) {
                    scriptParams = parser.map();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + name + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if ("rehash".equals(currentFieldName)) {
                    rehash = parser.booleanValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + name + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (PRECISION_THRESHOLD.match(currentFieldName)) {
                    precisionThreshold = parser.longValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + name + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + name + "].");
        }
        ValuesSourceConfig<ValuesSource> config = null;
        if (script != null) {
            config = new ValuesSourceConfig<BytesValuesSource>(BytesValuesSource.class);
            config.script(context.scriptService().search(context.lookup(), scriptLang, script, scriptParams));
        }
        if (field != null) {
            FieldMapper mapper = context.smartNameFieldMapper(field);
            if (config == null) {
                if (mapper instanceof NumberFieldMapper) {
                    config = new ValuesSourceConfig<NumericValuesSource>(NumericValuesSource.class);
                } else {
                    config = new ValuesSourceConfig<BytesValuesSource>(BytesValuesSource.class);
                    if (mapper == null) {
                        config.unmapped(true);
                    }
                }
                if (rehash == null && mapper instanceof Murmur3FieldMapper) {
                    rehash = false;
                }
            }
            if (mapper != null) {
                Object indexFieldData = context.fieldData().getForField(mapper);
                config.fieldContext(new FieldContext(field, (IndexFieldData<?>)indexFieldData));
            }
        } else if (config == null) {
            config = new ValuesSourceConfig<BytesValuesSource>(BytesValuesSource.class);
        }
        if (rehash == null) {
            rehash = true;
        }
        return new CardinalityAggregatorFactory(name, config, precisionThreshold, rehash);
    }
}

