/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregationBuilder;

public abstract class ValuesSourceMetricsAggregationBuilder<B extends ValuesSourceMetricsAggregationBuilder<B>>
extends MetricsAggregationBuilder<B> {
    private String field;
    private String script;
    private String lang;
    private Map<String, Object> params;

    protected ValuesSourceMetricsAggregationBuilder(String name, String type) {
        super(name, type);
    }

    public B field(String field) {
        this.field = field;
        return (B)this;
    }

    public B script(String script) {
        this.script = script;
        return (B)this;
    }

    public B lang(String lang) {
        this.lang = lang;
        return (B)this;
    }

    public B params(Map<String, Object> params) {
        if (this.params == null) {
            this.params = params;
        } else {
            this.params.putAll(params);
        }
        return (B)this;
    }

    public B param(String name, Object value) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name, value);
        return (B)this;
    }

    @Override
    protected void internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.script != null) {
            builder.field("script", this.script);
        }
        if (this.lang != null) {
            builder.field("lang", this.lang);
        }
        if (this.params != null && !this.params.isEmpty()) {
            builder.field("params").map(this.params);
        }
    }
}

