/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.StringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.bytes.BytesValuesSource;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class SignificantStringTermsAggregator
extends StringTermsAggregator {
    protected long numCollectedDocs;
    protected final SignificantTermsAggregatorFactory termsAggFactory;

    public SignificantStringTermsAggregator(String name, AggregatorFactories factories, ValuesSource valuesSource, long estimatedBucketCount, int requiredSize, int shardSize, long minDocCount, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggFactory) {
        super(name, factories, valuesSource, estimatedBucketCount, null, requiredSize, shardSize, minDocCount, includeExclude, aggregationContext, parent);
        this.termsAggFactory = termsAggFactory;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        super.collect(doc, owningBucketOrdinal);
        ++this.numCollectedDocs;
    }

    @Override
    public SignificantStringTerms buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L);
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.shardSize);
        ContextIndexSearcher searcher = this.context.searchContext().searcher();
        IndexReader topReader = searcher.getIndexReader();
        long supersetSize = topReader.numDocs();
        long subsetSize = this.numCollectedDocs;
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        SignificantStringTerms.Bucket spare = null;
        int i = 0;
        while ((long)i < this.bucketOrds.size()) {
            if (spare == null) {
                spare = new SignificantStringTerms.Bucket(new BytesRef(), 0L, 0L, 0L, 0L, null);
            }
            this.bucketOrds.get(i, spare.termBytes);
            spare.subsetDf = this.bucketDocCount(i);
            spare.subsetSize = subsetSize;
            spare.supersetDf = this.termsAggFactory.getBackgroundFrequency(spare.termBytes);
            spare.supersetSize = supersetSize;
            assert (spare.subsetDf <= spare.supersetDf);
            spare.updateScore();
            spare.bucketOrd = i;
            spare = (SignificantStringTerms.Bucket)ordered.insertWithOverflow(spare);
            ++i;
        }
        InternalSignificantTerms.Bucket[] list = new InternalSignificantTerms.Bucket[ordered.size()];
        for (int i2 = ordered.size() - 1; i2 >= 0; --i2) {
            SignificantStringTerms.Bucket bucket = (SignificantStringTerms.Bucket)ordered.pop();
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i2] = bucket;
        }
        return new SignificantStringTerms(subsetSize, supersetSize, this.name, this.requiredSize, this.minDocCount, Arrays.asList(list));
    }

    @Override
    public SignificantStringTerms buildEmptyAggregation() {
        ContextIndexSearcher searcher = this.context.searchContext().searcher();
        IndexReader topReader = searcher.getIndexReader();
        int supersetSize = topReader.numDocs();
        return new SignificantStringTerms(0L, supersetSize, this.name, this.requiredSize, this.minDocCount, Collections.<InternalSignificantTerms.Bucket>emptyList());
    }

    @Override
    public void doRelease() {
        Releasables.release(this.bucketOrds, this.termsAggFactory);
    }

    public static class WithOrdinals
    extends SignificantStringTermsAggregator {
        private final BytesValuesSource.WithOrdinals valuesSource;
        private BytesValues.WithOrdinals bytesValues;
        private Ordinals.Docs ordinals;
        private LongArray ordinalToBucket;

        public WithOrdinals(String name, AggregatorFactories factories, BytesValuesSource.WithOrdinals valuesSource, long esitmatedBucketCount, int requiredSize, int shardSize, long minDocCount, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggFactory) {
            super(name, factories, (ValuesSource)valuesSource, esitmatedBucketCount, requiredSize, shardSize, minDocCount, null, aggregationContext, parent, termsAggFactory);
            this.valuesSource = valuesSource;
        }

        @Override
        public void setNextReader(AtomicReaderContext reader) {
            this.bytesValues = this.valuesSource.bytesValues();
            this.ordinals = this.bytesValues.ordinals();
            long maxOrd = this.ordinals.getMaxOrd();
            if (this.ordinalToBucket == null || this.ordinalToBucket.size() < maxOrd) {
                if (this.ordinalToBucket != null) {
                    this.ordinalToBucket.release();
                }
                this.ordinalToBucket = this.context().bigArrays().newLongArray(BigArrays.overSize(maxOrd), false);
            }
            this.ordinalToBucket.fill(0L, maxOrd, -1L);
        }

        @Override
        public void collect(int doc, long owningBucketOrdinal) throws IOException {
            assert (owningBucketOrdinal == 0L) : "this is a per_bucket aggregator";
            ++this.numCollectedDocs;
            int valuesCount = this.ordinals.setDocument(doc);
            for (int i = 0; i < valuesCount; ++i) {
                long ord = this.ordinals.nextOrd();
                long bucketOrd = this.ordinalToBucket.get(ord);
                if (bucketOrd < 0L) {
                    BytesRef bytes = this.bytesValues.getValueByOrd(ord);
                    int hash = this.bytesValues.currentValueHash();
                    assert (hash == bytes.hashCode());
                    bucketOrd = this.bucketOrds.add(bytes, hash);
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                    }
                    this.ordinalToBucket.set(ord, bucketOrd);
                }
                this.collectBucket(doc, bucketOrd);
            }
        }

        @Override
        public void doRelease() {
            Releasables.release(this.bucketOrds, this.termsAggFactory, this.ordinalToBucket);
        }
    }
}

