/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantLongTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.LongTermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class SignificantLongTermsAggregator
extends LongTermsAggregator {
    protected long numCollectedDocs;
    private final SignificantTermsAggregatorFactory termsAggFactory;

    public SignificantLongTermsAggregator(String name, AggregatorFactories factories, NumericValuesSource valuesSource, long estimatedBucketCount, int requiredSize, int shardSize, long minDocCount, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggFactory) {
        super(name, factories, valuesSource, estimatedBucketCount, null, requiredSize, shardSize, minDocCount, aggregationContext, parent);
        this.termsAggFactory = termsAggFactory;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        super.collect(doc, owningBucketOrdinal);
        ++this.numCollectedDocs;
    }

    @Override
    public SignificantLongTerms buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L);
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.shardSize);
        ContextIndexSearcher searcher = this.context.searchContext().searcher();
        IndexReader topReader = searcher.getIndexReader();
        long supersetSize = topReader.numDocs();
        long subsetSize = this.numCollectedDocs;
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        SignificantLongTerms.Bucket spare = null;
        for (long i = 0L; i < this.bucketOrds.capacity(); ++i) {
            long ord = this.bucketOrds.id(i);
            if (ord < 0L) continue;
            if (spare == null) {
                spare = new SignificantLongTerms.Bucket(0L, 0L, 0L, 0L, 0L, null);
            }
            spare.term = this.bucketOrds.key(i);
            spare.subsetDf = this.bucketDocCount(ord);
            spare.subsetSize = subsetSize;
            spare.supersetDf = this.termsAggFactory.getBackgroundFrequency(spare.term);
            spare.supersetSize = supersetSize;
            assert (spare.subsetDf <= spare.supersetDf);
            spare.updateScore();
            spare.bucketOrd = ord;
            spare = (SignificantLongTerms.Bucket)ordered.insertWithOverflow(spare);
        }
        InternalSignificantTerms.Bucket[] list = new InternalSignificantTerms.Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            SignificantLongTerms.Bucket bucket = (SignificantLongTerms.Bucket)ordered.pop();
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i] = bucket;
        }
        return new SignificantLongTerms(subsetSize, supersetSize, this.name, this.valuesSource.formatter(), this.requiredSize, this.minDocCount, Arrays.asList(list));
    }

    @Override
    public SignificantLongTerms buildEmptyAggregation() {
        ContextIndexSearcher searcher = this.context.searchContext().searcher();
        IndexReader topReader = searcher.getIndexReader();
        int supersetSize = topReader.numDocs();
        return new SignificantLongTerms(0L, supersetSize, this.name, this.valuesSource.formatter(), this.requiredSize, this.minDocCount, Collections.<InternalSignificantTerms.Bucket>emptyList());
    }

    @Override
    public void doRelease() {
        Releasables.release(this.bucketOrds, this.termsAggFactory);
    }
}

