/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.support.numeric.ValueParser;
import org.elasticsearch.search.internal.SearchContext;

public class ExtendedBounds {
    Long min;
    Long max;
    String minAsStr;
    String maxAsStr;

    ExtendedBounds() {
    }

    ExtendedBounds(Long min, Long max) {
        this.min = min;
        this.max = max;
    }

    void processAndValidate(String aggName, SearchContext context, ValueParser parser) {
        if (this.minAsStr != null) {
            this.min = parser != null ? parser.parseLong(this.minAsStr, context) : Long.parseLong(this.minAsStr);
        }
        if (this.maxAsStr != null) {
            this.max = parser != null ? parser.parseLong(this.maxAsStr, context) : Long.parseLong(this.maxAsStr);
        }
        if (this.min != null && this.max != null && this.min.compareTo(this.max) > 0) {
            throw new SearchParseException(context, "[extended_bounds.min][" + this.min + "] cannot be greater than " + "[extended_bounds.max][" + this.max + "] for histogram aggregation [" + aggName + "]");
        }
    }

    ExtendedBounds round(Rounding rounding) {
        return new ExtendedBounds(this.min != null ? Long.valueOf(rounding.round(this.min)) : null, this.max != null ? Long.valueOf(rounding.round(this.max)) : null);
    }

    void writeTo(StreamOutput out) throws IOException {
        if (this.min != null) {
            out.writeBoolean(true);
            out.writeLong(this.min);
        } else {
            out.writeBoolean(false);
        }
        if (this.max != null) {
            out.writeBoolean(true);
            out.writeLong(this.max);
        } else {
            out.writeBoolean(false);
        }
    }

    static ExtendedBounds readFrom(StreamInput in) throws IOException {
        ExtendedBounds bounds = new ExtendedBounds();
        if (in.readBoolean()) {
            bounds.min = in.readLong();
        }
        if (in.readBoolean()) {
            bounds.max = in.readLong();
        }
        return bounds;
    }
}

