/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.info.PluginInfo;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.AbstractRestResponseActionListener;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.support.RestTable;

public class RestPluginsAction
extends AbstractCatAction {
    @Inject
    public RestPluginsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/plugins", this);
    }

    @Override
    void documentation(StringBuilder sb) {
        sb.append("/_cat/plugins\n");
    }

    @Override
    public void doRequest(RestRequest request, RestChannel channel) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().nodes(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        this.client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new AbstractRestResponseActionListener<ClusterStateResponse>(request, channel, this.logger){

            @Override
            public void onResponse(final ClusterStateResponse clusterStateResponse) {
                NodesInfoRequest nodesInfoRequest = new NodesInfoRequest();
                nodesInfoRequest.clear().plugins(true);
                RestPluginsAction.this.client.admin().cluster().nodesInfo(nodesInfoRequest, (ActionListener<NodesInfoResponse>)new AbstractRestResponseActionListener<NodesInfoResponse>(this.request, this.channel, this.logger){

                    @Override
                    public void onResponse(NodesInfoResponse nodesInfoResponse) {
                        try {
                            this.channel.sendResponse(RestTable.buildResponse(RestPluginsAction.this.buildTable(this.request, clusterStateResponse, nodesInfoResponse), this.request, this.channel));
                        }
                        catch (Throwable e) {
                            this.onFailure(e);
                        }
                    }
                });
            }
        });
    }

    @Override
    Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("name", "alias:n;desc:node name");
        table.addCell("component", "alias:c;desc:component");
        table.addCell("version", "alias:v;desc:component version");
        table.addCell("type", "alias:t;desc:type (j for JVM, s for Site)");
        table.addCell("url", "alias:u;desc:url for site plugins");
        table.addCell("description", "alias:d;default:false;desc:plugin details");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest req, ClusterStateResponse state, NodesInfoResponse nodesInfo) {
        DiscoveryNodes nodes = state.getState().nodes();
        Table table = this.getTableWithHeader(req);
        for (DiscoveryNode node : nodes) {
            NodeInfo info = (NodeInfo)nodesInfo.getNodesMap().get(node.id());
            for (PluginInfo pluginInfo : info.getPlugins().getInfos()) {
                table.startRow();
                table.addCell(node.name());
                table.addCell(pluginInfo.getName());
                table.addCell(pluginInfo.getVersion());
                String type = pluginInfo.isSite() ? (pluginInfo.isJvm() ? "j/s" : "s") : (pluginInfo.isJvm() ? "j" : "");
                table.addCell(type);
                table.addCell(pluginInfo.getUrl());
                table.addCell(pluginInfo.getDescription());
                table.endRow();
            }
        }
        return table;
    }
}

