/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.warmer.get;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.warmer.get.GetWarmersRequest;
import org.elasticsearch.action.admin.indices.warmer.get.GetWarmersResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class RestGetWarmerAction
extends BaseRestHandler {
    @Inject
    public RestGetWarmerAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_warmer", this);
        controller.registerHandler(RestRequest.Method.GET, "/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_warmer", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_warmers/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_warmer/{name}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String[] types = Strings.splitStringByCommaToArray(request.param("type"));
        String[] names = request.paramAsStringArray("name", Strings.EMPTY_ARRAY);
        GetWarmersRequest getWarmersRequest = new GetWarmersRequest();
        ((GetWarmersRequest)((GetWarmersRequest)getWarmersRequest.indices(indices)).types(types)).warmers(names);
        getWarmersRequest.local(request.paramAsBoolean("local", getWarmersRequest.local()));
        getWarmersRequest.indicesOptions(IndicesOptions.fromRequest(request, getWarmersRequest.indicesOptions()));
        this.client.admin().indices().getWarmers(getWarmersRequest, new ActionListener<GetWarmersResponse>(){

            @Override
            public void onResponse(GetWarmersResponse response) {
                try {
                    if (indices.length > 0 && response.warmers().isEmpty()) {
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, RestXContentBuilder.emptyBuilder(request)));
                        return;
                    }
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    for (ObjectObjectCursor<String, ImmutableList<IndexWarmersMetaData.Entry>> objectObjectCursor : response.warmers()) {
                        builder.startObject((String)objectObjectCursor.key, XContentBuilder.FieldCaseConversion.NONE);
                        builder.startObject("warmers", XContentBuilder.FieldCaseConversion.NONE);
                        for (IndexWarmersMetaData.Entry warmerEntry : (ImmutableList)objectObjectCursor.value) {
                            IndexWarmersMetaData.FACTORY.toXContent(warmerEntry, builder, (ToXContent.Params)request);
                        }
                        builder.endObject();
                        builder.endObject();
                    }
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestGetWarmerAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

