/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.pulsing.Pulsing41PostingsFormat;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.codec.postingsformat.AbstractPostingsFormatProvider;

public class PulsingPostingsFormatProvider
extends AbstractPostingsFormatProvider {
    private final int freqCutOff;
    private final int minBlockSize;
    private final int maxBlockSize;
    private final Pulsing41PostingsFormat postingsFormat;

    @Inject
    public PulsingPostingsFormatProvider(@Assisted String name, @Assisted Settings postingsFormatSettings) {
        super(name);
        this.freqCutOff = postingsFormatSettings.getAsInt("freq_cut_off", (Integer)1);
        this.minBlockSize = postingsFormatSettings.getAsInt("min_block_size", (Integer)25);
        this.maxBlockSize = postingsFormatSettings.getAsInt("max_block_size", (Integer)48);
        this.postingsFormat = new Pulsing41PostingsFormat(this.freqCutOff, this.minBlockSize, this.maxBlockSize);
    }

    public int freqCutOff() {
        return this.freqCutOff;
    }

    public int minBlockSize() {
        return this.minBlockSize;
    }

    public int maxBlockSize() {
        return this.maxBlockSize;
    }

    @Override
    public PostingsFormat get() {
        return this.postingsFormat;
    }
}

