/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.util.AbstractBigArray;

public final class BigFloatArrayList
extends AbstractBigArray {
    private static final int DEFAULT_PAGE_SIZE = 4096;
    private float[][] pages;

    public BigFloatArrayList(int pageSize, long initialCapacity) {
        super(pageSize, null, true);
        this.pages = new float[this.numPages(initialCapacity)][];
    }

    public BigFloatArrayList(long initialCapacity) {
        this(4096, initialCapacity);
    }

    public BigFloatArrayList() {
        this(1024L);
    }

    public float get(long index) {
        assert (index >= 0L && index < this.size);
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    public void add(float f) {
        int pageIndex = this.pageIndex(this.size);
        this.pages = ArrayUtil.grow((float[][])this.pages, (int)(pageIndex + 1));
        if (this.pages[pageIndex] == null) {
            this.pages[pageIndex] = new float[this.pageSize()];
        }
        int indexInPage = this.indexInPage(this.size);
        this.pages[pageIndex][indexInPage] = f;
        ++this.size;
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }
}

