/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.FloatArray;

final class BigFloatArray
extends AbstractBigArray
implements FloatArray {
    private float[][] pages;

    public BigFloatArray(long size, PageCacheRecycler recycler, boolean clearOnResize) {
        super(4096, recycler, clearOnResize);
        this.size = size;
        this.pages = new float[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newFloatPage(i);
        }
    }

    @Override
    public float set(long index, float value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        float[] page = this.pages[pageIndex];
        float ret = page[indexInPage];
        page[indexInPage] = value;
        return ret;
    }

    @Override
    public float increment(long index, float inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        float[] fArray = this.pages[pageIndex];
        int n = indexInPage;
        float f = fArray[n] + inc;
        fArray[n] = f;
        return f;
    }

    @Override
    public float get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (float[][])Arrays.copyOf(this.pages, ArrayUtil.oversize((int)numPages, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newFloatPage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    @Override
    public void fill(long fromIndex, long toIndex, float value) {
        Preconditions.checkArgument(fromIndex <= toIndex);
        int fromPage = this.pageIndex(fromIndex);
        int toPage = this.pageIndex(toIndex - 1L);
        if (fromPage == toPage) {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, value);
        } else {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.pages[fromPage].length, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                Arrays.fill(this.pages[i], value);
            }
            Arrays.fill(this.pages[toPage], 0, this.indexInPage(toIndex - 1L) + 1, value);
        }
    }
}

