/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.shard;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class SingleShardOperationRequest<T extends SingleShardOperationRequest>
extends ActionRequest<T> {
    protected String index;
    private boolean threadedOperation = true;

    protected SingleShardOperationRequest() {
    }

    public SingleShardOperationRequest(String index) {
        this.index = index;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    public String index() {
        return this.index;
    }

    public final T index(String index) {
        this.index = index;
        return (T)this;
    }

    public boolean operationThreaded() {
        return this.threadedOperation;
    }

    public final T operationThreaded(boolean threadedOperation) {
        this.threadedOperation = threadedOperation;
        return (T)this;
    }

    protected void beforeLocalFork() {
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
    }
}

