/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete.index;

import java.util.List;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.delete.index.IndexDeleteRequest;
import org.elasticsearch.action.delete.index.IndexDeleteResponse;
import org.elasticsearch.action.delete.index.ShardDeleteRequest;
import org.elasticsearch.action.delete.index.ShardDeleteResponse;
import org.elasticsearch.action.delete.index.TransportShardDeleteAction;
import org.elasticsearch.action.support.replication.TransportIndexReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndexDeleteAction
extends TransportIndexReplicationOperationAction<IndexDeleteRequest, IndexDeleteResponse, ShardDeleteRequest, ShardDeleteRequest, ShardDeleteResponse> {
    @Inject
    public TransportIndexDeleteAction(Settings settings, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, TransportShardDeleteAction deleteAction) {
        super(settings, transportService, clusterService, threadPool, deleteAction);
    }

    @Override
    protected IndexDeleteRequest newRequestInstance() {
        return new IndexDeleteRequest();
    }

    @Override
    protected IndexDeleteResponse newResponseInstance(IndexDeleteRequest request, List<ShardDeleteResponse> shardDeleteResponses, int failuresCount, List<ShardOperationFailedException> shardFailures) {
        return new IndexDeleteResponse(request.index(), failuresCount, shardDeleteResponses.toArray(new ShardDeleteResponse[shardDeleteResponses.size()]));
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    @Override
    protected String transportAction() {
        return "indices/index/delete";
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, IndexDeleteRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, IndexDeleteRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected GroupShardsIterator shards(IndexDeleteRequest request) {
        return this.clusterService.operationRouting().broadcastDeleteShards(this.clusterService.state(), request.index());
    }

    @Override
    protected ShardDeleteRequest newShardRequestInstance(IndexDeleteRequest request, int shardId) {
        return new ShardDeleteRequest(request, shardId);
    }
}

