/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class ShardValidateQueryRequest
extends BroadcastShardOperationRequest {
    private BytesReference source;
    private String[] types = Strings.EMPTY_ARRAY;
    private boolean explain;
    private long nowInMillis;
    @Nullable
    private String[] filteringAliases;

    ShardValidateQueryRequest() {
    }

    public ShardValidateQueryRequest(String index, int shardId, @Nullable String[] filteringAliases, ValidateQueryRequest request) {
        super(index, shardId, request);
        this.source = request.source();
        this.types = request.types();
        this.explain = request.explain();
        this.filteringAliases = filteringAliases;
        this.nowInMillis = request.nowInMillis;
    }

    public BytesReference source() {
        return this.source;
    }

    public String[] types() {
        return this.types;
    }

    public boolean explain() {
        return this.explain;
    }

    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int aliasesSize;
        super.readFrom(in);
        this.source = in.readBytesReference();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readString();
            }
        }
        if ((aliasesSize = in.readVInt()) > 0) {
            this.filteringAliases = new String[aliasesSize];
            for (int i = 0; i < aliasesSize; ++i) {
                this.filteringAliases[i] = in.readString();
            }
        }
        this.explain = in.readBoolean();
        this.nowInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.source);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeString(type);
        }
        if (this.filteringAliases != null) {
            out.writeVInt(this.filteringAliases.length);
            for (String alias : this.filteringAliases) {
                out.writeString(alias);
            }
        } else {
            out.writeVInt(0);
        }
        out.writeBoolean(this.explain);
        out.writeVLong(this.nowInMillis);
    }
}

