/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.cache.filter.FilterCacheStats;
import org.elasticsearch.index.cache.id.IdCacheStats;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.percolator.stats.PercolateStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.search.suggest.completion.CompletionStats;

public class CommonStats
implements Streamable,
ToXContent {
    @Nullable
    public DocsStats docs;
    @Nullable
    public StoreStats store;
    @Nullable
    public IndexingStats indexing;
    @Nullable
    public GetStats get;
    @Nullable
    public SearchStats search;
    @Nullable
    public MergeStats merge;
    @Nullable
    public RefreshStats refresh;
    @Nullable
    public FlushStats flush;
    @Nullable
    public WarmerStats warmer;
    @Nullable
    public FilterCacheStats filterCache;
    @Nullable
    public IdCacheStats idCache;
    @Nullable
    public FieldDataStats fieldData;
    @Nullable
    public PercolateStats percolate;
    @Nullable
    public CompletionStats completion;
    @Nullable
    public SegmentsStats segments;
    @Nullable
    public TranslogStats translog;

    public CommonStats() {
        this(CommonStatsFlags.NONE);
    }

    public CommonStats(CommonStatsFlags flags) {
        CommonStatsFlags.Flag[] setFlags;
        block18: for (CommonStatsFlags.Flag flag : setFlags = flags.getFlags()) {
            switch (flag) {
                case Docs: {
                    this.docs = new DocsStats();
                    continue block18;
                }
                case Store: {
                    this.store = new StoreStats();
                    continue block18;
                }
                case Indexing: {
                    this.indexing = new IndexingStats();
                    continue block18;
                }
                case Get: {
                    this.get = new GetStats();
                    continue block18;
                }
                case Search: {
                    this.search = new SearchStats();
                    continue block18;
                }
                case Merge: {
                    this.merge = new MergeStats();
                    continue block18;
                }
                case Refresh: {
                    this.refresh = new RefreshStats();
                    continue block18;
                }
                case Flush: {
                    this.flush = new FlushStats();
                    continue block18;
                }
                case Warmer: {
                    this.warmer = new WarmerStats();
                    continue block18;
                }
                case FilterCache: {
                    this.filterCache = new FilterCacheStats();
                    continue block18;
                }
                case IdCache: {
                    this.idCache = new IdCacheStats();
                    continue block18;
                }
                case FieldData: {
                    this.fieldData = new FieldDataStats();
                    continue block18;
                }
                case Completion: {
                    this.completion = new CompletionStats();
                    continue block18;
                }
                case Segments: {
                    this.segments = new SegmentsStats();
                    continue block18;
                }
                case Percolate: {
                    this.percolate = new PercolateStats();
                    continue block18;
                }
                case Translog: {
                    this.translog = new TranslogStats();
                    continue block18;
                }
                default: {
                    throw new IllegalStateException("Unknown Flag: " + (Object)((Object)flag));
                }
            }
        }
    }

    public CommonStats(IndexShard indexShard, CommonStatsFlags flags) {
        CommonStatsFlags.Flag[] setFlags;
        block18: for (CommonStatsFlags.Flag flag : setFlags = flags.getFlags()) {
            switch (flag) {
                case Docs: {
                    this.docs = indexShard.docStats();
                    continue block18;
                }
                case Store: {
                    this.store = indexShard.storeStats();
                    continue block18;
                }
                case Indexing: {
                    this.indexing = indexShard.indexingStats(flags.types());
                    continue block18;
                }
                case Get: {
                    this.get = indexShard.getStats();
                    continue block18;
                }
                case Search: {
                    this.search = indexShard.searchStats(flags.groups());
                    continue block18;
                }
                case Merge: {
                    this.merge = indexShard.mergeStats();
                    continue block18;
                }
                case Refresh: {
                    this.refresh = indexShard.refreshStats();
                    continue block18;
                }
                case Flush: {
                    this.flush = indexShard.flushStats();
                    continue block18;
                }
                case Warmer: {
                    this.warmer = indexShard.warmerStats();
                    continue block18;
                }
                case FilterCache: {
                    this.filterCache = indexShard.filterCacheStats();
                    continue block18;
                }
                case IdCache: {
                    this.idCache = indexShard.idCacheStats();
                    continue block18;
                }
                case FieldData: {
                    this.fieldData = indexShard.fieldDataStats(flags.fieldDataFields());
                    continue block18;
                }
                case Completion: {
                    this.completion = indexShard.completionStats(flags.completionDataFields());
                    continue block18;
                }
                case Segments: {
                    this.segments = indexShard.segmentStats();
                    continue block18;
                }
                case Percolate: {
                    this.percolate = indexShard.shardPercolateService().stats();
                    continue block18;
                }
                case Translog: {
                    this.translog = indexShard.translogStats();
                    continue block18;
                }
                default: {
                    throw new IllegalStateException("Unknown Flag: " + (Object)((Object)flag));
                }
            }
        }
    }

    public void add(CommonStats stats) {
        if (this.docs == null) {
            if (stats.getDocs() != null) {
                this.docs = new DocsStats();
                this.docs.add(stats.getDocs());
            }
        } else {
            this.docs.add(stats.getDocs());
        }
        if (this.store == null) {
            if (stats.getStore() != null) {
                this.store = new StoreStats();
                this.store.add(stats.getStore());
            }
        } else {
            this.store.add(stats.getStore());
        }
        if (this.indexing == null) {
            if (stats.getIndexing() != null) {
                this.indexing = new IndexingStats();
                this.indexing.add(stats.getIndexing());
            }
        } else {
            this.indexing.add(stats.getIndexing());
        }
        if (this.get == null) {
            if (stats.getGet() != null) {
                this.get = new GetStats();
                this.get.add(stats.getGet());
            }
        } else {
            this.get.add(stats.getGet());
        }
        if (this.search == null) {
            if (stats.getSearch() != null) {
                this.search = new SearchStats();
                this.search.add(stats.getSearch());
            }
        } else {
            this.search.add(stats.getSearch());
        }
        if (this.merge == null) {
            if (stats.getMerge() != null) {
                this.merge = new MergeStats();
                this.merge.add(stats.getMerge());
            }
        } else {
            this.merge.add(stats.getMerge());
        }
        if (this.refresh == null) {
            if (stats.getRefresh() != null) {
                this.refresh = new RefreshStats();
                this.refresh.add(stats.getRefresh());
            }
        } else {
            this.refresh.add(stats.getRefresh());
        }
        if (this.flush == null) {
            if (stats.getFlush() != null) {
                this.flush = new FlushStats();
                this.flush.add(stats.getFlush());
            }
        } else {
            this.flush.add(stats.getFlush());
        }
        if (this.warmer == null) {
            if (stats.getWarmer() != null) {
                this.warmer = new WarmerStats();
                this.warmer.add(stats.getWarmer());
            }
        } else {
            this.warmer.add(stats.getWarmer());
        }
        if (this.filterCache == null) {
            if (stats.getFilterCache() != null) {
                this.filterCache = new FilterCacheStats();
                this.filterCache.add(stats.getFilterCache());
            }
        } else {
            this.filterCache.add(stats.getFilterCache());
        }
        if (this.idCache == null) {
            if (stats.getIdCache() != null) {
                this.idCache = new IdCacheStats();
                this.idCache.add(stats.getIdCache());
            }
        } else {
            this.idCache.add(stats.getIdCache());
        }
        if (this.fieldData == null) {
            if (stats.getFieldData() != null) {
                this.fieldData = new FieldDataStats();
                this.fieldData.add(stats.getFieldData());
            }
        } else {
            this.fieldData.add(stats.getFieldData());
        }
        if (this.percolate == null) {
            if (stats.getPercolate() != null) {
                this.percolate = new PercolateStats();
                this.percolate.add(stats.getPercolate());
            }
        } else {
            this.percolate.add(stats.getPercolate());
        }
        if (this.completion == null) {
            if (stats.getCompletion() != null) {
                this.completion = new CompletionStats();
                this.completion.add(stats.getCompletion());
            }
        } else {
            this.completion.add(stats.getCompletion());
        }
        if (this.segments == null) {
            if (stats.getSegments() != null) {
                this.segments = new SegmentsStats();
                this.segments.add(stats.getSegments());
            }
        } else {
            this.segments.add(stats.getSegments());
        }
        if (this.translog == null) {
            if (stats.getTranslog() != null) {
                this.translog = new TranslogStats();
                this.translog.add(stats.getTranslog());
            }
        } else {
            this.translog.add(stats.getTranslog());
        }
    }

    @Nullable
    public DocsStats getDocs() {
        return this.docs;
    }

    @Nullable
    public StoreStats getStore() {
        return this.store;
    }

    @Nullable
    public IndexingStats getIndexing() {
        return this.indexing;
    }

    @Nullable
    public GetStats getGet() {
        return this.get;
    }

    @Nullable
    public SearchStats getSearch() {
        return this.search;
    }

    @Nullable
    public MergeStats getMerge() {
        return this.merge;
    }

    @Nullable
    public RefreshStats getRefresh() {
        return this.refresh;
    }

    @Nullable
    public FlushStats getFlush() {
        return this.flush;
    }

    @Nullable
    public WarmerStats getWarmer() {
        return this.warmer;
    }

    @Nullable
    public FilterCacheStats getFilterCache() {
        return this.filterCache;
    }

    @Nullable
    public IdCacheStats getIdCache() {
        return this.idCache;
    }

    @Nullable
    public FieldDataStats getFieldData() {
        return this.fieldData;
    }

    @Nullable
    public PercolateStats getPercolate() {
        return this.percolate;
    }

    @Nullable
    public CompletionStats getCompletion() {
        return this.completion;
    }

    @Nullable
    public SegmentsStats getSegments() {
        return this.segments;
    }

    @Nullable
    public TranslogStats getTranslog() {
        return this.translog;
    }

    public static CommonStats readCommonStats(StreamInput in) throws IOException {
        CommonStats stats = new CommonStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.docs = DocsStats.readDocStats(in);
        }
        if (in.readBoolean()) {
            this.store = StoreStats.readStoreStats(in);
        }
        if (in.readBoolean()) {
            this.indexing = IndexingStats.readIndexingStats(in);
        }
        if (in.readBoolean()) {
            this.get = GetStats.readGetStats(in);
        }
        if (in.readBoolean()) {
            this.search = SearchStats.readSearchStats(in);
        }
        if (in.readBoolean()) {
            this.merge = MergeStats.readMergeStats(in);
        }
        if (in.readBoolean()) {
            this.refresh = RefreshStats.readRefreshStats(in);
        }
        if (in.readBoolean()) {
            this.flush = FlushStats.readFlushStats(in);
        }
        if (in.readBoolean()) {
            this.warmer = WarmerStats.readWarmerStats(in);
        }
        if (in.readBoolean()) {
            this.filterCache = FilterCacheStats.readFilterCacheStats(in);
        }
        if (in.readBoolean()) {
            this.idCache = IdCacheStats.readIdCacheStats(in);
        }
        if (in.readBoolean()) {
            this.fieldData = FieldDataStats.readFieldDataStats(in);
        }
        if (in.readBoolean()) {
            this.percolate = PercolateStats.readPercolateStats(in);
        }
        if (in.readBoolean()) {
            this.completion = CompletionStats.readCompletionStats(in);
        }
        if (in.readBoolean()) {
            this.segments = SegmentsStats.readSegmentsStats(in);
        }
        this.translog = in.readOptionalStreamable(new TranslogStats());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.docs == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.docs.writeTo(out);
        }
        if (this.store == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.store.writeTo(out);
        }
        if (this.indexing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.indexing.writeTo(out);
        }
        if (this.get == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.get.writeTo(out);
        }
        if (this.search == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.search.writeTo(out);
        }
        if (this.merge == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.merge.writeTo(out);
        }
        if (this.refresh == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.refresh.writeTo(out);
        }
        if (this.flush == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.flush.writeTo(out);
        }
        if (this.warmer == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.warmer.writeTo(out);
        }
        if (this.filterCache == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.filterCache.writeTo(out);
        }
        if (this.idCache == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.idCache.writeTo(out);
        }
        if (this.fieldData == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.fieldData.writeTo(out);
        }
        if (this.percolate == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.percolate.writeTo(out);
        }
        if (this.completion == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.completion.writeTo(out);
        }
        if (this.segments == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.segments.writeTo(out);
        }
        out.writeOptionalStreamable(this.translog);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.docs != null) {
            this.docs.toXContent(builder, params);
        }
        if (this.store != null) {
            this.store.toXContent(builder, params);
        }
        if (this.indexing != null) {
            this.indexing.toXContent(builder, params);
        }
        if (this.get != null) {
            this.get.toXContent(builder, params);
        }
        if (this.search != null) {
            this.search.toXContent(builder, params);
        }
        if (this.merge != null) {
            this.merge.toXContent(builder, params);
        }
        if (this.refresh != null) {
            this.refresh.toXContent(builder, params);
        }
        if (this.flush != null) {
            this.flush.toXContent(builder, params);
        }
        if (this.warmer != null) {
            this.warmer.toXContent(builder, params);
        }
        if (this.filterCache != null) {
            this.filterCache.toXContent(builder, params);
        }
        if (this.idCache != null) {
            this.idCache.toXContent(builder, params);
        }
        if (this.fieldData != null) {
            this.fieldData.toXContent(builder, params);
        }
        if (this.percolate != null) {
            this.percolate.toXContent(builder, params);
        }
        if (this.completion != null) {
            this.completion.toXContent(builder, params);
        }
        if (this.segments != null) {
            this.segments.toXContent(builder, params);
        }
        if (this.translog != null) {
            this.translog.toXContent(builder, params);
        }
        return builder;
    }
}

