/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;

public final class StoreUtils {
    private StoreUtils() {
    }

    public static String toString(Directory directory) {
        if (directory instanceof NIOFSDirectory) {
            NIOFSDirectory niofsDirectory = (NIOFSDirectory)directory;
            return "niofs(" + niofsDirectory.getDirectory() + ")";
        }
        if (directory instanceof MMapDirectory) {
            MMapDirectory mMapDirectory = (MMapDirectory)directory;
            return "mmapfs(" + mMapDirectory.getDirectory() + ")";
        }
        if (directory instanceof SimpleFSDirectory) {
            SimpleFSDirectory simpleFSDirectory = (SimpleFSDirectory)directory;
            return "simplefs(" + simpleFSDirectory.getDirectory() + ")";
        }
        return directory.toString();
    }
}

