/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.merge.OnGoingMerge;

public class TrackingSerialMergeScheduler
extends MergeScheduler {
    protected final ESLogger logger;
    private final MeanMetric totalMerges = new MeanMetric();
    private final CounterMetric totalMergesNumDocs = new CounterMetric();
    private final CounterMetric totalMergesSizeInBytes = new CounterMetric();
    private final CounterMetric currentMerges = new CounterMetric();
    private final CounterMetric currentMergesNumDocs = new CounterMetric();
    private final CounterMetric currentMergesSizeInBytes = new CounterMetric();
    private final Set<OnGoingMerge> onGoingMerges = ConcurrentCollections.newConcurrentSet();
    private final Set<OnGoingMerge> readOnlyOnGoingMerges = Collections.unmodifiableSet(this.onGoingMerges);
    private final int maxMergeAtOnce;

    public TrackingSerialMergeScheduler(ESLogger logger, int maxMergeAtOnce) {
        this.logger = logger;
        this.maxMergeAtOnce = maxMergeAtOnce;
    }

    public long totalMerges() {
        return this.totalMerges.count();
    }

    public long totalMergeTime() {
        return this.totalMerges.sum();
    }

    public long totalMergeNumDocs() {
        return this.totalMergesNumDocs.count();
    }

    public long totalMergeSizeInBytes() {
        return this.totalMergesSizeInBytes.count();
    }

    public long currentMerges() {
        return this.currentMerges.count();
    }

    public long currentMergesNumDocs() {
        return this.currentMergesNumDocs.count();
    }

    public long currentMergesSizeInBytes() {
        return this.currentMergesSizeInBytes.count();
    }

    public Set<OnGoingMerge> onGoingMerges() {
        return this.readOnlyOnGoingMerges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void merge(IndexWriter writer) throws CorruptIndexException, IOException {
        MergePolicy.OneMerge merge;
        int cycle = 0;
        while (cycle++ < this.maxMergeAtOnce && (merge = writer.getNextMerge()) != null) {
            writer.mergeInit(merge);
            int totalNumDocs = merge.totalNumDocs();
            long totalSizeInBytes = merge.estimatedMergeBytes;
            long time = System.currentTimeMillis();
            this.currentMerges.inc();
            this.currentMergesNumDocs.inc(totalNumDocs);
            this.currentMergesSizeInBytes.inc(totalSizeInBytes);
            OnGoingMerge onGoingMerge = new OnGoingMerge(merge);
            this.onGoingMerges.add(onGoingMerge);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("merge [{}] starting..., merging [{}] segments, [{}] docs, [{}] size, into [{}] estimated_size", merge.info == null ? "_na_" : merge.info.info.name, merge.segments.size(), totalNumDocs, new ByteSizeValue(totalSizeInBytes), new ByteSizeValue(merge.estimatedMergeBytes));
            }
            try {
                this.beforeMerge(onGoingMerge);
                writer.merge(merge);
            }
            catch (Throwable throwable) {
                long took = System.currentTimeMillis() - time;
                this.onGoingMerges.remove(onGoingMerge);
                this.afterMerge(onGoingMerge);
                this.currentMerges.dec();
                this.currentMergesNumDocs.dec(totalNumDocs);
                this.currentMergesSizeInBytes.dec(totalSizeInBytes);
                this.totalMergesNumDocs.inc(totalNumDocs);
                this.totalMergesSizeInBytes.inc(totalSizeInBytes);
                this.totalMerges.inc(took);
                if (took > 20000L) {
                    this.logger.debug("merge [{}] done, took [{}]", merge.info == null ? "_na_" : merge.info.info.name, TimeValue.timeValueMillis(took));
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace("merge [{}] done, took [{}]", merge.info == null ? "_na_" : merge.info.info.name, TimeValue.timeValueMillis(took));
                }
                throw throwable;
            }
            long took = System.currentTimeMillis() - time;
            this.onGoingMerges.remove(onGoingMerge);
            this.afterMerge(onGoingMerge);
            this.currentMerges.dec();
            this.currentMergesNumDocs.dec(totalNumDocs);
            this.currentMergesSizeInBytes.dec(totalSizeInBytes);
            this.totalMergesNumDocs.inc(totalNumDocs);
            this.totalMergesSizeInBytes.inc(totalSizeInBytes);
            this.totalMerges.inc(took);
            if (took > 20000L) {
                this.logger.debug("merge [{}] done, took [{}]", merge.info == null ? "_na_" : merge.info.info.name, TimeValue.timeValueMillis(took));
                continue;
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("merge [{}] done, took [{}]", merge.info == null ? "_na_" : merge.info.info.name, TimeValue.timeValueMillis(took));
        }
    }

    protected void beforeMerge(OnGoingMerge merge) {
    }

    protected void afterMerge(OnGoingMerge merge) {
    }

    public void close() {
    }

    public MergeScheduler clone() {
        return this;
    }
}

