/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.renderkit;

import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.validator.Validator;
import org.jboss.seam.ui.component.UIEqualityValidator;
import org.jboss.seam.ui.util.cdk.RendererBase;
import org.jboss.seam.ui.validator.EqualityValidator;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class EqualityValidatorRendererBase
extends RendererBase
implements ComponentSystemEventListener {
    @Override
    protected Class getComponentClass() {
        return UIEqualityValidator.class;
    }

    private void attachValidator(UIComponent component) {
        UIEqualityValidator ev = (UIEqualityValidator)component;
        EditableValueHolder evh = null;
        if (ev != null && ev.getParent() instanceof EditableValueHolder) {
            evh = (EditableValueHolder)ev.getParent();
        }
        if (evh == null) {
            throw new IllegalArgumentException("validateEquality tag must be nested in an EditableValueHolder (\"input tag\")");
        }
        if (!this.hasEqualityValidator(evh)) {
            evh.addValidator((Validator)new EqualityValidator(ev.getFor(), ev.getMessage(), ev.getMessageId(), ev.getOperator()));
            evh.setRequired(ev.isRequired());
        }
    }

    private boolean hasEqualityValidator(EditableValueHolder evh) {
        for (Validator validator : evh.getValidators()) {
            if (!(validator instanceof EqualityValidator)) continue;
            return true;
        }
        return false;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        this.attachValidator(component);
    }
}

