/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit;

import java.sql.Connection;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryServiceImpl;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SimpleDataSource;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public class TestSQLDirectories
extends NXRuntimeTestCase {
    @Before
    public void setUp() throws Exception {
        super.setUp();
        DatabaseHelper.DATABASE.setUp();
        this.deployBundle("org.nuxeo.ecm.core.schema");
        this.deployBundle("org.nuxeo.ecm.core.api");
        this.deployBundle("org.nuxeo.ecm.core");
        this.deployBundle("org.nuxeo.ecm.core.event");
        this.deployBundle("org.nuxeo.ecm.directory");
        this.deployBundle("org.nuxeo.ecm.directory.sql");
        this.deployBundle("org.nuxeo.ecm.directory.types.contrib");
        this.deployBundle("org.nuxeo.ecm.platform.audit.api");
        this.deployContrib("org.nuxeo.ecm.platform.audit.tests", "OSGI-INF/test-directories-contrib.xml");
    }

    protected static Session getSession(String dirName) throws ClientException {
        DirectoryService dirService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        return dirService.open(dirName);
    }

    protected static Directory getDirectory(String dirName) throws DirectoryException {
        DirectoryServiceImpl dirServiceImpl = (DirectoryServiceImpl)Framework.getRuntime().getComponent(DirectoryService.NAME);
        Directory dir = dirServiceImpl.getDirectory(dirName);
        return dir;
    }

    public Connection getConnection() throws Exception {
        return new SimpleDataSource("jdbc:hsqldb:mem:memid", "org.hsqldb.jdbcDriver", "sa", "").getConnection();
    }

    public static void setUpContextFactory() {
        Properties props = System.getProperties();
        props.put("java.naming.factory.initial", "org.nuxeo.ecm.directory.sql.LocalContextFactory");
    }

    @Test
    public void testDirectories() throws Exception {
        Directory eventDir = TestSQLDirectories.getDirectory("eventTypes");
        Assert.assertNotNull((Object)eventDir);
        Directory categoryDir = TestSQLDirectories.getDirectory("eventCategories");
        Assert.assertNotNull((Object)categoryDir);
    }
}

