/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.nuxeo.ecm.platform.audit.PersistenceTestCase;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.query.AuditQueryException;
import org.nuxeo.ecm.platform.audit.api.query.DateRangeParser;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.audit.service.LogEntryProvider;

public class TestLogEntryProvider
extends PersistenceTestCase {
    protected static final Log log = LogFactory.getLog(TestLogEntryProvider.class);
    private LogEntryProvider providerUnderTest;

    @Override
    protected void handleAfterSetup(EntityManager entityManager) {
        this.providerUnderTest = LogEntryProvider.createProvider((EntityManager)entityManager);
    }

    protected Map<String, ExtendedInfo> createExtendedInfos() {
        HashMap<String, ExtendedInfo> infos = new HashMap<String, ExtendedInfo>();
        ExtendedInfoImpl info = ExtendedInfoImpl.createExtendedInfo((Serializable)new Long(1L));
        infos.put("id", (ExtendedInfo)info);
        return infos;
    }

    protected String eventId() {
        return TestLogEntryProvider.class.getSimpleName();
    }

    protected String[] eventIds() {
        return new String[]{this.eventId()};
    }

    protected LogEntry doCreateEntry(String docId) {
        LogEntryImpl createdEntry = new LogEntryImpl();
        createdEntry.setEventId(this.eventId());
        createdEntry.setDocUUID(docId);
        createdEntry.setEventDate(new Date());
        createdEntry.setDocPath("/" + docId);
        createdEntry.setRepositoryId("test");
        createdEntry.setExtendedInfos(this.createExtendedInfos());
        return createdEntry;
    }

    protected LogEntry doCreateEntryAndPersist(String docId) {
        LogEntry entry = this.doCreateEntry(docId);
        this.entityManager.persist((Object)entry);
        return entry;
    }

    protected List<LogEntry> doEncapsulate(LogEntry entry) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>(1);
        entries.add(entry);
        return entries;
    }

    @Test
    public void testAddLogEntry() {
        LogEntry entry = this.doCreateEntry("id");
        this.providerUnderTest.addLogEntry(entry);
        boolean hasId = entry.getId() != 0L;
        Assert.assertTrue((boolean)hasId);
    }

    @Test
    public void testHavingKey() {
        LogEntry entry = this.doCreateEntryAndPersist("id");
        this.providerUnderTest.addLogEntry(entry);
        List entries = this.providerUnderTest.nativeQueryLogs("log.id = " + entry.getId() + " and log.extendedInfos['id'] is not null", 1, 10);
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((Object)new Long(1L), (Object)((ExtendedInfo)((LogEntry)entries.get(0)).getExtendedInfos().get("id")).getValue(Long.class));
    }

    @Test
    public void testByUUID() {
        LogEntry entry = this.doCreateEntryAndPersist("id");
        this.providerUnderTest.addLogEntry(entry);
        List fetchedEntries = this.providerUnderTest.getLogEntriesFor("id");
        Assert.assertNotNull((Object)fetchedEntries);
        int entriesCount = fetchedEntries.size();
        Assert.assertEquals((long)1L, (long)entriesCount);
        LogEntry fetchedEntry = (LogEntry)fetchedEntries.get(0);
        Assert.assertNotNull((Object)fetchedEntry);
        Assert.assertEquals((Object)"id", (Object)fetchedEntry.getDocUUID());
    }

    @Test
    public void testByFilter() throws Exception {
        LogEntry one = this.doCreateEntryAndPersist("id");
        Thread.sleep(1000L);
        LogEntry two = this.doCreateEntryAndPersist("id");
        HashMap<String, FilterMapEntry> filters = new HashMap<String, FilterMapEntry>();
        FilterMapEntry filterOne = new FilterMapEntry();
        filterOne.setQueryParameterName("yop");
        filterOne.setColumnName("eventDate");
        filterOne.setOperator("=");
        filterOne.setObject((Object)one.getEventDate());
        filters.put("oups", filterOne);
        List entries = this.providerUnderTest.getLogEntriesFor("id", filters, true);
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((long)one.getId(), (long)((LogEntry)entries.get(0)).getId());
    }

    @Test
    public void testById() {
        LogEntry one = this.doCreateEntryAndPersist("id");
        LogEntry fetchedEntry = this.providerUnderTest.getLogEntryByID(one.getId());
        Assert.assertNotNull((Object)fetchedEntry);
        Assert.assertEquals((long)one.getId(), (long)fetchedEntry.getId());
    }

    @Test
    public void testByNativeQuery() {
        this.doCreateEntryAndPersist("one");
        this.doCreateEntryAndPersist("two");
        List entries = this.providerUnderTest.nativeQueryLogs("log.extendedInfos['id'] is not null order by log.eventDate desc", 2, 1);
        Assert.assertNotNull((Object)entries);
        int entryCount = entries.size();
        Assert.assertEquals((long)1L, (long)entryCount);
    }

    @Test
    public void testDateRange() throws AuditQueryException {
        Date now = new Date();
        Date nowMinusOneHour = DateRangeParser.parseDateRangeQuery((Date)now, (String)"-1h");
        LogEntry one = this.doCreateEntryAndPersist("one");
        one.setEventDate(nowMinusOneHour);
        LogEntry two = this.doCreateEntryAndPersist("two");
        two.setEventDate(now);
        this.entityManager.flush();
        List entries = this.providerUnderTest.queryLogs(this.eventIds(), "-40m");
        Assert.assertNotNull((Object)entries);
        int entryCount = entries.size();
        Assert.assertEquals((long)1L, (long)entryCount);
    }

    @Test
    public void testLogsByPage() throws Exception {
        LogEntry one = this.doCreateEntryAndPersist("one");
        Thread.sleep(1000L);
        Date limit = new Date();
        LogEntry two = this.doCreateEntryAndPersist("two");
        LogEntry three = this.doCreateEntryAndPersist("three");
        one.setCategory("nuch");
        three.setCategory("nuch");
        String[] categories = new String[]{"nuch"};
        List entries = this.providerUnderTest.queryLogsByPage(this.eventIds(), limit, categories, "/", 1, 1);
        Assert.assertNotNull((Object)entries);
        int entryCount = entries.size();
        Assert.assertEquals((long)1L, (long)entryCount);
        Assert.assertEquals((Object)"three", (Object)((LogEntry)entries.get(0)).getDocUUID());
    }

    @Test
    public void testRemove() {
        LogEntry one = this.doCreateEntryAndPersist("one");
        LogEntry two = this.doCreateEntryAndPersist("two");
        LogEntry three = this.doCreateEntryAndPersist("three");
        int count = this.providerUnderTest.removeEntries(this.eventId(), "/");
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testCountEventsById() {
        LogEntry one = this.doCreateEntryAndPersist("one");
        String eventId = one.getEventId();
        Long count = this.providerUnderTest.countEventsById(eventId);
        Assert.assertEquals((Object)new Long(1L), (Object)count);
    }

    @Test
    public void testQuery() {
        LogEntry one = this.doCreateEntryAndPersist("one");
        LogEntry two = this.doCreateEntryAndPersist("two");
        LogEntry three = this.doCreateEntryAndPersist("three");
        one.setCategory("nuch");
        three.setCategory("nuch");
        List entries = this.providerUnderTest.nativeQuery("select log.eventId, count(*) from LogEntry log where log.eventId = 'TestLogEntryProvider' group by log.eventId", 1, 1);
        Assert.assertNotNull((Object)entries);
        int entryCount = entries.size();
        Assert.assertEquals((long)1L, (long)entryCount);
        Object[] entry = (Object[])entries.get(0);
        String name = (String)entry[0];
        Long count = (Long)entry[1];
        Assert.assertEquals((Object)"TestLogEntryProvider", (Object)name);
        Assert.assertEquals((Object)new Long(3L), (Object)count);
    }

    @Test
    @Ignore
    public void testEventIds() {
        String eventId = this.eventId();
        LogEntry one = this.doCreateEntryAndPersist("one");
        LogEntry two = this.doCreateEntryAndPersist("two");
        List eventIds = this.providerUnderTest.findEventIds();
        Assert.assertEquals((long)1L, (long)eventIds.size());
        Assert.assertEquals((Object)eventId, eventIds.get(0));
    }
}

